/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.actuate.stat;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="initializr.stats")
public class StatsProperties {
    @NestedConfigurationProperty
    private final Elastic elastic = new Elastic();

    public Elastic getElastic() {
        return this.elastic;
    }

    public static final class Elastic {
        private String uri;
        private String username;
        private String password;
        private String indexName = "initializr";
        private String entityName = "request";
        private int maxAttempts = 3;

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getIndexName() {
            return this.indexName;
        }

        public void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        public int getMaxAttempts() {
            return this.maxAttempts;
        }

        public void setMaxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = Elastic.cleanUri(uri);
        }

        private static String cleanUri(String contextPath) {
            if (StringUtils.hasText((String)contextPath) && contextPath.endsWith("/")) {
                return contextPath.substring(0, contextPath.length() - 1);
            }
            return contextPath;
        }
    }
}

