/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.code.groovy;

import io.spring.initializr.generator.buildsystem.Build;
import io.spring.initializr.generator.condition.ConditionalOnBuildSystem;
import io.spring.initializr.generator.condition.ConditionalOnPackaging;
import io.spring.initializr.generator.language.Annotation;
import io.spring.initializr.generator.language.Parameter;
import io.spring.initializr.generator.language.groovy.GroovyExpression;
import io.spring.initializr.generator.language.groovy.GroovyExpressionStatement;
import io.spring.initializr.generator.language.groovy.GroovyMethodDeclaration;
import io.spring.initializr.generator.language.groovy.GroovyMethodInvocation;
import io.spring.initializr.generator.language.groovy.GroovyReturnStatement;
import io.spring.initializr.generator.language.groovy.GroovyStatement;
import io.spring.initializr.generator.language.groovy.GroovyTypeDeclaration;
import io.spring.initializr.generator.project.ProjectDescription;
import io.spring.initializr.generator.spring.build.BuildCustomizer;
import io.spring.initializr.generator.spring.code.MainApplicationTypeCustomizer;
import io.spring.initializr.generator.spring.code.ServletInitializerCustomizer;
import io.spring.initializr.generator.spring.code.TestApplicationTypeCustomizer;
import io.spring.initializr.generator.spring.code.groovy.GroovyDependenciesConfigurer;
import io.spring.initializr.generator.spring.code.groovy.GroovyGradleBuildCustomizer;
import io.spring.initializr.generator.spring.code.groovy.GroovyMavenBuildCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
class GroovyProjectGenerationDefaultContributorsConfiguration {
    GroovyProjectGenerationDefaultContributorsConfiguration() {
    }

    @Bean
    MainApplicationTypeCustomizer<GroovyTypeDeclaration> mainMethodContributor() {
        return typeDeclaration -> typeDeclaration.addMethodDeclaration(GroovyMethodDeclaration.method((String)"main").modifiers(9).returning("void").parameters(new Parameter[]{new Parameter("java.lang.String[]", "args")}).body(new GroovyStatement[]{new GroovyExpressionStatement((GroovyExpression)new GroovyMethodInvocation("org.springframework.boot.SpringApplication", "run", new String[]{typeDeclaration.getName(), "args"}))}));
    }

    @Bean
    TestApplicationTypeCustomizer<GroovyTypeDeclaration> junitJupiterTestMethodContributor() {
        return typeDeclaration -> {
            GroovyMethodDeclaration method = GroovyMethodDeclaration.method((String)"contextLoads").returning("void").body(new GroovyStatement[0]);
            method.annotate(Annotation.name((String)"org.junit.jupiter.api.Test"));
            typeDeclaration.addMethodDeclaration(method);
        };
    }

    @Bean
    BuildCustomizer<Build> groovyDependenciesConfigurer() {
        return new GroovyDependenciesConfigurer();
    }

    @Configuration
    @ConditionalOnBuildSystem(value="gradle")
    static class GroovyGradleProjectConfiguration {
        GroovyGradleProjectConfiguration() {
        }

        @Bean
        GroovyGradleBuildCustomizer groovyBuildCustomizer() {
            return new GroovyGradleBuildCustomizer();
        }
    }

    @Configuration
    @ConditionalOnBuildSystem(value="maven")
    static class GroovyMavenProjectConfiguration {
        GroovyMavenProjectConfiguration() {
        }

        @Bean
        GroovyMavenBuildCustomizer groovyBuildCustomizer() {
            return new GroovyMavenBuildCustomizer();
        }
    }

    @Configuration
    @ConditionalOnPackaging(value="war")
    static class WarPackagingConfiguration {
        WarPackagingConfiguration() {
        }

        @Bean
        ServletInitializerCustomizer<GroovyTypeDeclaration> javaServletInitializerCustomizer(ProjectDescription description) {
            return typeDeclaration -> {
                GroovyMethodDeclaration configure = GroovyMethodDeclaration.method((String)"configure").modifiers(4).returning("org.springframework.boot.builder.SpringApplicationBuilder").parameters(new Parameter[]{new Parameter("org.springframework.boot.builder.SpringApplicationBuilder", "application")}).body(new GroovyStatement[]{new GroovyReturnStatement((GroovyExpression)new GroovyMethodInvocation("application", "sources", new String[]{description.getApplicationName()}))});
                configure.annotate(Annotation.name((String)"java.lang.Override"));
                typeDeclaration.addMethodDeclaration(configure);
            };
        }
    }
}

