/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.documentation;

import io.spring.initializr.generator.io.text.Section;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class PreDefinedSection
implements Section {
    private final String title;
    private final List<Section> subSections = new ArrayList<Section>();

    public PreDefinedSection(String title) {
        this.title = title;
    }

    public PreDefinedSection addSection(Section section) {
        this.subSections.add(section);
        return this;
    }

    public void write(PrintWriter writer) throws IOException {
        if (!this.isEmpty()) {
            writer.println("# " + this.title);
            writer.println("");
            for (Section section : this.resolveSubSections(this.subSections)) {
                section.write(writer);
            }
        }
    }

    public boolean isEmpty() {
        return this.subSections.isEmpty();
    }

    protected List<Section> resolveSubSections(List<Section> sections) {
        return sections;
    }
}

