/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.documentation;

import io.spring.initializr.generator.io.text.BulletedSection;
import io.spring.initializr.generator.project.ProjectDescription;
import io.spring.initializr.generator.spring.documentation.GettingStartedSection;
import io.spring.initializr.generator.spring.documentation.HelpDocument;
import io.spring.initializr.generator.spring.documentation.HelpDocumentCustomizer;
import io.spring.initializr.metadata.Dependency;
import io.spring.initializr.metadata.InitializrMetadata;
import io.spring.initializr.metadata.Link;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;

public class RequestedDependenciesHelpDocumentCustomizer
implements HelpDocumentCustomizer {
    private final ProjectDescription description;
    private final InitializrMetadata metadata;
    private final String defaultPlatformVersion;

    public RequestedDependenciesHelpDocumentCustomizer(ProjectDescription description, InitializrMetadata metadata) {
        this.description = description;
        this.metadata = metadata;
        this.defaultPlatformVersion = metadata.getBootVersions().getDefault().getId();
    }

    @Override
    public void customize(HelpDocument document) {
        this.description.getRequestedDependencies().forEach((id, dependency) -> {
            Dependency dependencyMetadata = this.metadata.getDependencies().get(id);
            if (dependencyMetadata != null) {
                this.handleDependency(document, dependencyMetadata);
            }
        });
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    private void handleDependency(HelpDocument document, Dependency dependency) {
        GettingStartedSection gettingStartedSection = document.gettingStarted();
        MultiValueMap<GuideType, Link> indexedLinks = this.indexLinks(dependency);
        this.registerLinks((List)indexedLinks.get((Object)GuideType.REFERENCE), this.defaultLinkDescription(dependency), gettingStartedSection::referenceDocs);
        this.registerLinks((List)indexedLinks.get((Object)GuideType.GUIDE), this.defaultLinkDescription(dependency), gettingStartedSection::guides);
        this.registerLinks((List)indexedLinks.get((Object)GuideType.OTHER), links -> null, gettingStartedSection::additionalLinks);
    }

    private void registerLinks(List<Link> links, Function<List<Link>, String> defaultDescription, Supplier<BulletedSection<GettingStartedSection.Link>> section) {
        if (ObjectUtils.isEmpty(links)) {
            return;
        }
        links.forEach(link -> {
            if (link.getHref() != null) {
                String description;
                String string = description = link.getDescription() != null ? link.getDescription() : (String)defaultDescription.apply(links);
                if (description != null) {
                    String url = link.getHref().replace("{bootVersion}", this.defaultPlatformVersion);
                    ((BulletedSection)section.get()).addItem((Object)new GettingStartedSection.Link(url, description));
                }
            }
        });
    }

    private Function<List<Link>, String> defaultLinkDescription(Dependency dependency) {
        return links -> links.size() == 1 ? dependency.getName() : null;
    }

    private MultiValueMap<GuideType, Link> indexLinks(Dependency dependency) {
        LinkedMultiValueMap links = new LinkedMultiValueMap();
        dependency.getLinks().forEach(arg_0 -> RequestedDependenciesHelpDocumentCustomizer.lambda$indexLinks$4((MultiValueMap)links, arg_0));
        return links;
    }

    private static /* synthetic */ void lambda$indexLinks$4(MultiValueMap links, Link link) {
        if ("reference".equals(link.getRel())) {
            links.add((Object)GuideType.REFERENCE, (Object)link);
        } else if ("guide".equals(link.getRel())) {
            links.add((Object)GuideType.GUIDE, (Object)link);
        } else {
            links.add((Object)GuideType.OTHER, (Object)link);
        }
    }

    private static enum GuideType {
        REFERENCE,
        GUIDE,
        OTHER;

    }
}

