/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.code.kotlin;

import io.spring.initializr.generator.buildsystem.maven.MavenBuild;
import io.spring.initializr.generator.spring.build.BuildCustomizer;
import io.spring.initializr.generator.spring.code.kotlin.KotlinProjectSettings;

class KotlinMavenFullBuildCustomizer
implements BuildCustomizer<MavenBuild> {
    private final KotlinProjectSettings settings;

    KotlinMavenFullBuildCustomizer(KotlinProjectSettings kotlinProjectSettings) {
        this.settings = kotlinProjectSettings;
    }

    @Override
    public void customize(MavenBuild build) {
        build.properties().version("kotlin.version", this.settings.getVersion());
        build.settings().sourceDirectory("${project.basedir}/src/main/kotlin").testSourceDirectory("${project.basedir}/src/test/kotlin");
        build.plugins().add("org.jetbrains.kotlin", "kotlin-maven-plugin", kotlinMavenPlugin -> {
            kotlinMavenPlugin.version("${kotlin.version}");
            kotlinMavenPlugin.configuration(configuration -> {
                configuration.configure("args", args -> this.settings.getCompilerArgs().forEach(arg -> args.add("arg", arg)));
                configuration.configure("compilerPlugins", compilerPlugins -> compilerPlugins.add("plugin", "spring"));
                configuration.add("jvmTarget", this.settings.getJvmTarget());
            });
            kotlinMavenPlugin.execution("compile", compile -> compile.phase("compile").goal("compile"));
            kotlinMavenPlugin.execution("test-compile", compile -> compile.phase("test-compile").goal("test-compile"));
            kotlinMavenPlugin.dependency("org.jetbrains.kotlin", "kotlin-maven-allopen", "${kotlin.version}");
        });
    }
}

