/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.code.kotlin;

import io.spring.initializr.generator.buildsystem.Build;
import io.spring.initializr.generator.condition.ConditionalOnBuildSystem;
import io.spring.initializr.generator.condition.ConditionalOnPackaging;
import io.spring.initializr.generator.condition.ConditionalOnPlatformVersion;
import io.spring.initializr.generator.language.Annotation;
import io.spring.initializr.generator.language.Parameter;
import io.spring.initializr.generator.language.kotlin.KotlinCompilationUnit;
import io.spring.initializr.generator.language.kotlin.KotlinExpression;
import io.spring.initializr.generator.language.kotlin.KotlinExpressionStatement;
import io.spring.initializr.generator.language.kotlin.KotlinFunctionDeclaration;
import io.spring.initializr.generator.language.kotlin.KotlinFunctionInvocation;
import io.spring.initializr.generator.language.kotlin.KotlinModifier;
import io.spring.initializr.generator.language.kotlin.KotlinReifiedFunctionInvocation;
import io.spring.initializr.generator.language.kotlin.KotlinReturnStatement;
import io.spring.initializr.generator.language.kotlin.KotlinStatement;
import io.spring.initializr.generator.language.kotlin.KotlinTypeDeclaration;
import io.spring.initializr.generator.project.ProjectDescription;
import io.spring.initializr.generator.spring.build.BuildCustomizer;
import io.spring.initializr.generator.spring.code.MainCompilationUnitCustomizer;
import io.spring.initializr.generator.spring.code.ServletInitializerCustomizer;
import io.spring.initializr.generator.spring.code.TestApplicationTypeCustomizer;
import io.spring.initializr.generator.spring.code.kotlin.GroovyDslKotlinGradleBuildCustomizer;
import io.spring.initializr.generator.spring.code.kotlin.KotlinDependenciesConfigurer;
import io.spring.initializr.generator.spring.code.kotlin.KotlinDslKotlinGradleBuildCustomizer;
import io.spring.initializr.generator.spring.code.kotlin.KotlinGradleBuildCustomizer;
import io.spring.initializr.generator.spring.code.kotlin.KotlinJpaGradleBuildCustomizer;
import io.spring.initializr.generator.spring.code.kotlin.KotlinJpaMavenBuildCustomizer;
import io.spring.initializr.generator.spring.code.kotlin.KotlinMavenBuildCustomizer;
import io.spring.initializr.generator.spring.code.kotlin.KotlinProjectSettings;
import io.spring.initializr.metadata.InitializrMetadata;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
class KotlinProjectGenerationDefaultContributorsConfiguration {
    KotlinProjectGenerationDefaultContributorsConfiguration() {
    }

    @Bean
    TestApplicationTypeCustomizer<KotlinTypeDeclaration> junitJupiterTestMethodContributor() {
        return typeDeclaration -> {
            KotlinFunctionDeclaration function = KotlinFunctionDeclaration.function((String)"contextLoads").body(new KotlinStatement[0]);
            function.annotate(Annotation.name((String)"org.junit.jupiter.api.Test"));
            typeDeclaration.addFunctionDeclaration(function);
        };
    }

    @Bean
    BuildCustomizer<Build> kotlinDependenciesConfigurer() {
        return new KotlinDependenciesConfigurer();
    }

    @Bean
    @ConditionalOnBuildSystem(value="gradle")
    KotlinJpaGradleBuildCustomizer kotlinJpaGradleBuildCustomizer(InitializrMetadata metadata, KotlinProjectSettings settings) {
        return new KotlinJpaGradleBuildCustomizer(metadata, settings);
    }

    @Bean
    @ConditionalOnBuildSystem(value="maven")
    KotlinJpaMavenBuildCustomizer kotlinJpaMavenBuildCustomizer(InitializrMetadata metadata) {
        return new KotlinJpaMavenBuildCustomizer(metadata);
    }

    @Configuration
    @ConditionalOnBuildSystem(id="gradle", dialect="kotlin")
    static class KotlinGradleKtsProjectConfiguration {
        KotlinGradleKtsProjectConfiguration() {
        }

        @Bean
        KotlinDslKotlinGradleBuildCustomizer kotlinBuildCustomizer(KotlinProjectSettings kotlinProjectSettings) {
            return new KotlinDslKotlinGradleBuildCustomizer(kotlinProjectSettings);
        }
    }

    @Configuration
    @ConditionalOnBuildSystem(id="gradle", dialect="groovy")
    static class KotlinGradleProjectConfiguration {
        KotlinGradleProjectConfiguration() {
        }

        @Bean
        KotlinGradleBuildCustomizer kotlinBuildCustomizer(KotlinProjectSettings kotlinProjectSettings) {
            return new GroovyDslKotlinGradleBuildCustomizer(kotlinProjectSettings);
        }
    }

    @Configuration
    @ConditionalOnPackaging(value="war")
    static class WarPackagingConfiguration {
        WarPackagingConfiguration() {
        }

        @Bean
        ServletInitializerCustomizer<KotlinTypeDeclaration> javaServletInitializerCustomizer(ProjectDescription description) {
            return typeDeclaration -> {
                KotlinFunctionDeclaration configure = KotlinFunctionDeclaration.function((String)"configure").modifiers(new KotlinModifier[]{KotlinModifier.OVERRIDE}).returning("org.springframework.boot.builder.SpringApplicationBuilder").parameters(new Parameter[]{new Parameter("org.springframework.boot.builder.SpringApplicationBuilder", "application")}).body(new KotlinStatement[]{new KotlinReturnStatement((KotlinExpression)new KotlinFunctionInvocation("application", "sources", new String[]{description.getApplicationName() + "::class.java"}))});
                typeDeclaration.addFunctionDeclaration(configure);
            };
        }
    }

    @Configuration
    @ConditionalOnPlatformVersion(value={"2.0.0.M1"})
    static class SpringBoot2AndLaterKotlinProjectGenerationConfiguration {
        SpringBoot2AndLaterKotlinProjectGenerationConfiguration() {
        }

        @Bean
        @ConditionalOnBuildSystem(value="maven")
        KotlinMavenBuildCustomizer kotlinBuildCustomizer(KotlinProjectSettings kotlinProjectSettings) {
            return new KotlinMavenBuildCustomizer(kotlinProjectSettings);
        }

        @Bean
        MainCompilationUnitCustomizer<KotlinTypeDeclaration, KotlinCompilationUnit> mainFunctionContributor(ProjectDescription description) {
            return compilationUnit -> compilationUnit.addTopLevelFunction(KotlinFunctionDeclaration.function((String)"main").parameters(new Parameter[]{new Parameter("Array<String>", "args")}).body(new KotlinStatement[]{new KotlinExpressionStatement((KotlinExpression)new KotlinReifiedFunctionInvocation("org.springframework.boot.runApplication", description.getApplicationName(), new String[]{"*args"}))}));
        }
    }
}

