/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.dependency.devtools;

import io.spring.initializr.generator.buildsystem.Dependency;
import io.spring.initializr.generator.buildsystem.gradle.GradleBuild;
import io.spring.initializr.generator.buildsystem.gradle.GradleDependency;
import io.spring.initializr.generator.spring.build.BuildCustomizer;
import io.spring.initializr.generator.version.Version;
import io.spring.initializr.generator.version.VersionParser;
import io.spring.initializr.generator.version.VersionRange;

public class DevToolsGradleBuildCustomizer
implements BuildCustomizer<GradleBuild> {
    private static final VersionRange SPRING_BOOT_2_3_0_RC1_OR_LATER = VersionParser.DEFAULT.parseRange("2.3.0.RC1");
    private final Version platformVersion;
    private final String devtoolsDependencyId;

    public DevToolsGradleBuildCustomizer(Version platformVersion, String devtoolsDependencyId) {
        this.platformVersion = platformVersion;
        this.devtoolsDependencyId = devtoolsDependencyId;
    }

    @Override
    public void customize(GradleBuild build) {
        Dependency devtools = (Dependency)build.dependencies().get((Object)this.devtoolsDependencyId);
        if (devtools == null) {
            return;
        }
        if (!SPRING_BOOT_2_3_0_RC1_OR_LATER.match(this.platformVersion)) {
            build.configurations().add("developmentOnly");
            build.configurations().customize("runtimeClasspath", runtimeClasspath -> runtimeClasspath.extendsFrom("developmentOnly"));
        }
        build.dependencies().add(this.devtoolsDependencyId, (Dependency.Builder)GradleDependency.from((Dependency)devtools).configuration("developmentOnly"));
    }
}

