/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.build;

import io.spring.initializr.generator.buildsystem.Build;
import io.spring.initializr.generator.buildsystem.Dependency;
import io.spring.initializr.generator.buildsystem.DependencyScope;
import io.spring.initializr.generator.condition.ConditionalOnPackaging;
import io.spring.initializr.generator.condition.ConditionalOnPlatformVersion;
import io.spring.initializr.generator.project.ProjectDescription;
import io.spring.initializr.generator.project.ProjectGenerationConfiguration;
import io.spring.initializr.generator.spring.build.BuildCustomizer;
import io.spring.initializr.generator.spring.build.DefaultStarterBuildCustomizer;
import io.spring.initializr.generator.spring.build.DependencyManagementBuildCustomizer;
import io.spring.initializr.generator.spring.build.SimpleBuildCustomizer;
import io.spring.initializr.generator.spring.build.SpringBootVersionRepositoriesBuildCustomizer;
import io.spring.initializr.generator.spring.build.WarPackagingWebStarterBuildCustomizer;
import io.spring.initializr.generator.spring.build.maven.DefaultMavenBuildCustomizer;
import io.spring.initializr.metadata.InitializrMetadata;
import org.springframework.context.annotation.Bean;

@ProjectGenerationConfiguration
public class BuildProjectGenerationConfiguration {
    @Bean
    @ConditionalOnPlatformVersion(value={"[2.2.0.M5,2.4.0-SNAPSHOT)"})
    public BuildCustomizer<Build> junit5TestStarterContributor() {
        return build -> build.dependencies().add("test", Dependency.withCoordinates((String)"org.springframework.boot", (String)"spring-boot-starter-test").scope(DependencyScope.TEST_COMPILE).exclusions(new Dependency.Exclusion[]{new Dependency.Exclusion("org.junit.vintage", "junit-vintage-engine")}));
    }

    @Bean
    @ConditionalOnPlatformVersion(value={"2.4.0-M1"})
    public BuildCustomizer<Build> junitJupiterTestStarterContributor() {
        return build -> build.dependencies().add("test", Dependency.withCoordinates((String)"org.springframework.boot", (String)"spring-boot-starter-test").scope(DependencyScope.TEST_COMPILE));
    }

    @Bean
    public DefaultStarterBuildCustomizer defaultStarterContributor(InitializrMetadata metadata) {
        return new DefaultStarterBuildCustomizer(metadata);
    }

    @Bean
    public DefaultMavenBuildCustomizer initializrMetadataMavenBuildCustomizer(ProjectDescription description, InitializrMetadata metadata) {
        return new DefaultMavenBuildCustomizer(description, metadata);
    }

    @Bean
    @ConditionalOnPackaging(value="war")
    public WarPackagingWebStarterBuildCustomizer warPackagingWebStarterBuildCustomizer(InitializrMetadata metadata) {
        return new WarPackagingWebStarterBuildCustomizer(metadata);
    }

    @Bean
    public DependencyManagementBuildCustomizer dependencyManagementBuildCustomizer(ProjectDescription description, InitializrMetadata metadata) {
        return new DependencyManagementBuildCustomizer(description, metadata);
    }

    @Bean
    public SimpleBuildCustomizer projectDescriptionBuildCustomizer(ProjectDescription description) {
        return new SimpleBuildCustomizer(description);
    }

    @Bean
    public SpringBootVersionRepositoriesBuildCustomizer repositoriesBuilderCustomizer(ProjectDescription description) {
        return new SpringBootVersionRepositoriesBuildCustomizer(description.getPlatformVersion());
    }
}

