/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.build;

import io.spring.initializr.generator.buildsystem.Build;
import io.spring.initializr.generator.buildsystem.MavenRepository;
import io.spring.initializr.generator.spring.build.BuildCustomizer;
import io.spring.initializr.generator.version.Version;

class SpringBootVersionRepositoriesBuildCustomizer
implements BuildCustomizer<Build> {
    private static final MavenRepository SPRING_MILESTONES = MavenRepository.withIdAndUrl((String)"spring-milestones", (String)"https://repo.spring.io/milestone").name("Spring Milestones").onlyReleases().build();
    private static final MavenRepository SPRING_SNAPSHOTS = MavenRepository.withIdAndUrl((String)"spring-snapshots", (String)"https://repo.spring.io/snapshot").name("Spring Snapshots").onlySnapshots().build();
    private final Version springBootVersion;

    SpringBootVersionRepositoriesBuildCustomizer(Version springBootVersion) {
        this.springBootVersion = springBootVersion;
    }

    @Override
    public void customize(Build build) {
        String qualifier;
        build.repositories().add((Object)"maven-central");
        if (this.springBootVersion.getQualifier() != null && !(qualifier = this.springBootVersion.getQualifier().getId()).equals("RELEASE")) {
            this.addMilestoneRepository(build);
            if (qualifier.contains("SNAPSHOT")) {
                this.addSnapshotRepository(build);
            }
        }
    }

    private void addSnapshotRepository(Build build) {
        build.repositories().add(SPRING_SNAPSHOTS);
        build.pluginRepositories().add(SPRING_SNAPSHOTS);
    }

    private void addMilestoneRepository(Build build) {
        build.repositories().add(SPRING_MILESTONES);
        build.pluginRepositories().add(SPRING_MILESTONES);
    }
}

