/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.build.gradle;

import io.spring.initializr.generator.buildsystem.BuildItemResolver;
import io.spring.initializr.generator.buildsystem.gradle.GradleBuild;
import io.spring.initializr.generator.buildsystem.gradle.GradleBuildWriter;
import io.spring.initializr.generator.buildsystem.gradle.GradleSettingsWriter;
import io.spring.initializr.generator.buildsystem.gradle.GroovyDslGradleBuildWriter;
import io.spring.initializr.generator.buildsystem.gradle.GroovyDslGradleSettingsWriter;
import io.spring.initializr.generator.buildsystem.gradle.KotlinDslGradleBuildWriter;
import io.spring.initializr.generator.buildsystem.gradle.KotlinDslGradleSettingsWriter;
import io.spring.initializr.generator.condition.ConditionalOnBuildSystem;
import io.spring.initializr.generator.condition.ConditionalOnLanguage;
import io.spring.initializr.generator.condition.ConditionalOnPackaging;
import io.spring.initializr.generator.condition.ConditionalOnPlatformVersion;
import io.spring.initializr.generator.io.IndentingWriterFactory;
import io.spring.initializr.generator.project.ProjectDescription;
import io.spring.initializr.generator.project.ProjectGenerationConfiguration;
import io.spring.initializr.generator.spring.build.BuildCustomizer;
import io.spring.initializr.generator.spring.build.gradle.ConditionalOnGradleVersion;
import io.spring.initializr.generator.spring.build.gradle.DependencyManagementPluginVersionResolver;
import io.spring.initializr.generator.spring.build.gradle.GradleAnnotationProcessorScopeBuildCustomizer;
import io.spring.initializr.generator.spring.build.gradle.GradleBuildProjectContributor;
import io.spring.initializr.generator.spring.build.gradle.GradleConfigurationBuildCustomizer;
import io.spring.initializr.generator.spring.build.gradle.GradleWrapperContributor;
import io.spring.initializr.generator.spring.build.gradle.InitializrDependencyManagementPluginVersionResolver;
import io.spring.initializr.generator.spring.build.gradle.SettingsGradleProjectContributor;
import io.spring.initializr.generator.spring.build.gradle.SpringBootPluginBuildCustomizer;
import io.spring.initializr.generator.spring.util.LambdaSafe;
import io.spring.initializr.metadata.InitializrMetadata;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ProjectGenerationConfiguration
@ConditionalOnBuildSystem(value="gradle")
public class GradleProjectGenerationConfiguration {
    private static final int LANGUAGE_PLUGINS_ORDER = -2147483643;
    private static final int PACKAGING_PLUGINS_ORDER = -2147483638;
    private static final int TEST_ORDER = 100;
    private final IndentingWriterFactory indentingWriterFactory;

    public GradleProjectGenerationConfiguration(IndentingWriterFactory indentingWriterFactory) {
        this.indentingWriterFactory = indentingWriterFactory;
    }

    @Bean
    public GradleBuild gradleBuild(ObjectProvider<BuildItemResolver> buildItemResolver, ObjectProvider<BuildCustomizer<?>> buildCustomizers) {
        return this.createGradleBuild((BuildItemResolver)buildItemResolver.getIfAvailable(), buildCustomizers.orderedStream().collect(Collectors.toList()));
    }

    private GradleBuild createGradleBuild(BuildItemResolver buildItemResolver, List<BuildCustomizer<?>> buildCustomizers) {
        GradleBuild build = buildItemResolver != null ? new GradleBuild(buildItemResolver) : new GradleBuild();
        LambdaSafe.callbacks(BuildCustomizer.class, buildCustomizers, build, new Object[0]).invoke(customizer -> customizer.customize(build));
        return build;
    }

    @Bean
    public BuildCustomizer<GradleBuild> defaultGradleBuildCustomizer(ProjectDescription description) {
        return build -> build.settings().sourceCompatibility(description.getLanguage().jvmVersion());
    }

    @Bean
    public GradleConfigurationBuildCustomizer gradleConfigurationBuildCustomizer() {
        return new GradleConfigurationBuildCustomizer();
    }

    @Bean
    @ConditionalOnLanguage(value="java")
    public BuildCustomizer<GradleBuild> javaPluginContributor() {
        return BuildCustomizer.ordered(-2147483643, build -> build.plugins().add("java"));
    }

    @Bean
    @ConditionalOnLanguage(value="groovy")
    public BuildCustomizer<GradleBuild> groovyPluginContributor() {
        return BuildCustomizer.ordered(-2147483643, build -> build.plugins().add("groovy"));
    }

    @Bean
    @ConditionalOnPackaging(value="war")
    public BuildCustomizer<GradleBuild> warPluginContributor() {
        return BuildCustomizer.ordered(-2147483638, build -> build.plugins().add("war"));
    }

    @Bean
    @ConditionalOnGradleVersion(value={"6", "7", "8"})
    BuildCustomizer<GradleBuild> springBootPluginContributor(ProjectDescription description, ObjectProvider<DependencyManagementPluginVersionResolver> versionResolver, InitializrMetadata metadata) {
        return new SpringBootPluginBuildCustomizer(description, (DependencyManagementPluginVersionResolver)versionResolver.getIfAvailable(() -> new InitializrDependencyManagementPluginVersionResolver(metadata)));
    }

    @Bean
    @ConditionalOnBuildSystem(id="gradle", dialect="groovy")
    public GradleBuildProjectContributor gradleBuildProjectContributor(GroovyDslGradleBuildWriter buildWriter, GradleBuild build) {
        return new GradleBuildProjectContributor((GradleBuildWriter)buildWriter, build, this.indentingWriterFactory, "build.gradle");
    }

    @Bean
    @ConditionalOnBuildSystem(id="gradle", dialect="kotlin")
    public GradleBuildProjectContributor gradleKtsBuildProjectContributor(KotlinDslGradleBuildWriter buildWriter, GradleBuild build) {
        return new GradleBuildProjectContributor((GradleBuildWriter)buildWriter, build, this.indentingWriterFactory, "build.gradle.kts");
    }

    @Configuration
    @ConditionalOnBuildSystem(id="gradle", dialect="kotlin")
    @ConditionalOnGradleVersion(value={"6", "7", "8"})
    static class GradleKtsProjectGenerationConfiguration {
        GradleKtsProjectGenerationConfiguration() {
        }

        @Bean
        KotlinDslGradleBuildWriter gradleKtsBuildWriter() {
            return new KotlinDslGradleBuildWriter();
        }

        @Bean
        SettingsGradleProjectContributor settingsGradleKtsProjectContributor(GradleBuild build, IndentingWriterFactory indentingWriterFactory) {
            return new SettingsGradleProjectContributor(build, indentingWriterFactory, (GradleSettingsWriter)new KotlinDslGradleSettingsWriter(), "settings.gradle.kts");
        }

        @Bean
        @ConditionalOnPlatformVersion(value={"2.2.0.M3"})
        BuildCustomizer<GradleBuild> testTaskContributor() {
            return BuildCustomizer.ordered(100, build -> build.tasks().customizeWithType("Test", test -> test.invoke("useJUnitPlatform", new String[0])));
        }

        @Bean
        GradleAnnotationProcessorScopeBuildCustomizer gradleAnnotationProcessorScopeBuildCustomizer() {
            return new GradleAnnotationProcessorScopeBuildCustomizer();
        }
    }

    @Configuration
    @ConditionalOnBuildSystem(id="gradle", dialect="groovy")
    @ConditionalOnGradleVersion(value={"6", "7", "8"})
    static class GradleGroovyProjectGenerationConfiguration {
        GradleGroovyProjectGenerationConfiguration() {
        }

        @Bean
        GroovyDslGradleBuildWriter gradleBuildWriter() {
            return new GroovyDslGradleBuildWriter();
        }

        @Bean
        SettingsGradleProjectContributor settingsGradleProjectContributor(GradleBuild build, IndentingWriterFactory indentingWriterFactory) {
            return new SettingsGradleProjectContributor(build, indentingWriterFactory, (GradleSettingsWriter)new GroovyDslGradleSettingsWriter(), "settings.gradle");
        }

        @Bean
        @ConditionalOnPlatformVersion(value={"2.2.0.M3"})
        BuildCustomizer<GradleBuild> testTaskContributor() {
            return BuildCustomizer.ordered(100, build -> build.tasks().customize("test", test -> test.invoke("useJUnitPlatform", new String[0])));
        }

        @Bean
        GradleAnnotationProcessorScopeBuildCustomizer gradleAnnotationProcessorScopeBuildCustomizer() {
            return new GradleAnnotationProcessorScopeBuildCustomizer();
        }
    }

    @Configuration
    @ConditionalOnGradleVersion(value={"8"})
    static class Gradle8ProjectGenerationConfiguration {
        Gradle8ProjectGenerationConfiguration() {
        }

        @Bean
        GradleWrapperContributor gradle7WrapperContributor() {
            return new GradleWrapperContributor("8");
        }
    }

    @Configuration
    @ConditionalOnGradleVersion(value={"7"})
    static class Gradle7ProjectGenerationConfiguration {
        Gradle7ProjectGenerationConfiguration() {
        }

        @Bean
        GradleWrapperContributor gradle7WrapperContributor() {
            return new GradleWrapperContributor("7");
        }
    }

    @Configuration
    @ConditionalOnGradleVersion(value={"6"})
    @Deprecated
    static class Gradle6ProjectGenerationConfiguration {
        Gradle6ProjectGenerationConfiguration() {
        }

        @Bean
        GradleWrapperContributor gradle6WrapperContributor() {
            return new GradleWrapperContributor("6");
        }
    }
}

