/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.code.kotlin;

import io.spring.initializr.generator.buildsystem.gradle.GradleBuild;
import io.spring.initializr.generator.buildsystem.gradle.GradleTask;
import io.spring.initializr.generator.spring.build.BuildCustomizer;
import io.spring.initializr.generator.spring.code.kotlin.KotlinProjectSettings;

abstract class KotlinGradleBuildCustomizer
implements BuildCustomizer<GradleBuild> {
    private final KotlinProjectSettings settings;

    KotlinGradleBuildCustomizer(KotlinProjectSettings kotlinProjectSettings) {
        this.settings = kotlinProjectSettings;
    }

    @Override
    public void customize(GradleBuild build) {
        build.plugins().add("org.jetbrains.kotlin.jvm", plugin -> plugin.setVersion(this.settings.getVersion()));
        build.plugins().add("org.jetbrains.kotlin.plugin.spring", plugin -> plugin.setVersion(this.settings.getVersion()));
        build.tasks().customizeWithType("org.jetbrains.kotlin.gradle.tasks.KotlinCompile", compile -> this.customizeKotlinOptions(this.settings, (GradleTask.Builder)compile));
    }

    protected abstract void customizeKotlinOptions(KotlinProjectSettings var1, GradleTask.Builder var2);
}

