/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.code.kotlin;

import io.spring.initializr.generator.buildsystem.Build;
import io.spring.initializr.generator.buildsystem.DependencyScope;
import io.spring.initializr.generator.language.kotlin.KotlinLanguage;
import io.spring.initializr.generator.project.ProjectDescription;
import io.spring.initializr.generator.spring.build.BuildCustomizer;
import io.spring.initializr.generator.spring.build.BuildMetadataResolver;
import io.spring.initializr.metadata.InitializrMetadata;
import org.springframework.util.ClassUtils;

public class KotlinJacksonBuildCustomizer
implements BuildCustomizer<Build> {
    private final BuildMetadataResolver buildMetadataResolver;
    private final ProjectDescription description;

    public KotlinJacksonBuildCustomizer(InitializrMetadata metadata, ProjectDescription description) {
        this.buildMetadataResolver = new BuildMetadataResolver(metadata);
        this.description = description;
    }

    @Override
    public void customize(Build build) {
        boolean isKotlin = ClassUtils.isAssignableValue(KotlinLanguage.class, (Object)this.description.getLanguage());
        if (this.buildMetadataResolver.hasFacet(build, "json") && isKotlin) {
            build.dependencies().add("jackson-module-kotlin", "com.fasterxml.jackson.module", "jackson-module-kotlin", DependencyScope.COMPILE);
        }
    }
}

