/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.scm.git;

import io.spring.initializr.generator.io.text.Section;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.LinkedList;

public class GitIgnore {
    private final GitIgnoreSection general = new GitIgnoreSection(null);
    private final GitIgnoreSection sts = new GitIgnoreSection("STS");
    private final GitIgnoreSection intellijIdea = new GitIgnoreSection("IntelliJ IDEA");
    private final GitIgnoreSection netBeans = new GitIgnoreSection("NetBeans");
    private final GitIgnoreSection vscode = new GitIgnoreSection("VS Code");

    public void write(PrintWriter writer) throws IOException {
        this.general.write(writer);
        this.sts.write(writer);
        this.intellijIdea.write(writer);
        this.netBeans.write(writer);
        this.vscode.write(writer);
    }

    public boolean isEmpty() {
        return this.general.getItems().isEmpty() && this.sts.getItems().isEmpty() && this.intellijIdea.getItems().isEmpty() && this.netBeans.getItems().isEmpty() && this.vscode.getItems().isEmpty();
    }

    public GitIgnoreSection getGeneral() {
        return this.general;
    }

    public GitIgnoreSection getSts() {
        return this.sts;
    }

    public GitIgnoreSection getIntellijIdea() {
        return this.intellijIdea;
    }

    public GitIgnoreSection getNetBeans() {
        return this.netBeans;
    }

    public GitIgnoreSection getVscode() {
        return this.vscode;
    }

    public static class GitIgnoreSection
    implements Section {
        private final String name;
        private final LinkedList<String> items;

        public GitIgnoreSection(String name) {
            this.name = name;
            this.items = new LinkedList();
        }

        public void add(String ... items) {
            this.items.addAll(Arrays.asList(items));
        }

        public LinkedList<String> getItems() {
            return this.items;
        }

        public void write(PrintWriter writer) {
            if (!this.items.isEmpty()) {
                if (this.name != null) {
                    writer.println();
                    writer.println(String.format("### %s ###", this.name));
                }
                this.items.forEach(writer::println);
            }
        }
    }
}

