/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.build.maven;

import io.spring.initializr.generator.buildsystem.BuildItemResolver;
import io.spring.initializr.generator.buildsystem.maven.MavenBuild;
import io.spring.initializr.generator.condition.ConditionalOnBuildSystem;
import io.spring.initializr.generator.condition.ConditionalOnPackaging;
import io.spring.initializr.generator.condition.ConditionalOnPlatformVersion;
import io.spring.initializr.generator.io.IndentingWriterFactory;
import io.spring.initializr.generator.project.ProjectGenerationConfiguration;
import io.spring.initializr.generator.spring.build.BuildCustomizer;
import io.spring.initializr.generator.spring.build.maven.MavenBuildProjectContributor;
import io.spring.initializr.generator.spring.build.maven.MavenWrapperContributor;
import io.spring.initializr.generator.spring.util.LambdaSafe;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;

@ProjectGenerationConfiguration
@ConditionalOnBuildSystem(value="maven")
public class MavenProjectGenerationConfiguration {
    @Bean
    @ConditionalOnPlatformVersion(value={"[2.0.0.M1,3.1.0-RC1)"})
    public MavenWrapperContributor maven38WrapperContributor() {
        return new MavenWrapperContributor("3.8");
    }

    @Bean
    @ConditionalOnPlatformVersion(value={"3.1.0-RC1"})
    public MavenWrapperContributor mavenWrapperContributor() {
        return new MavenWrapperContributor("3");
    }

    @Bean
    public MavenBuild mavenBuild(ObjectProvider<BuildItemResolver> buildItemResolver, ObjectProvider<BuildCustomizer<?>> buildCustomizers) {
        return this.createBuild((BuildItemResolver)buildItemResolver.getIfAvailable(), buildCustomizers.orderedStream().collect(Collectors.toList()));
    }

    private MavenBuild createBuild(BuildItemResolver buildItemResolver, List<BuildCustomizer<?>> buildCustomizers) {
        MavenBuild build = buildItemResolver != null ? new MavenBuild(buildItemResolver) : new MavenBuild();
        LambdaSafe.callbacks(BuildCustomizer.class, buildCustomizers, build, new Object[0]).invoke(customizer -> customizer.customize(build));
        return build;
    }

    @Bean
    public MavenBuildProjectContributor mavenBuildProjectContributor(MavenBuild build, IndentingWriterFactory indentingWriterFactory) {
        return new MavenBuildProjectContributor(build, indentingWriterFactory);
    }

    @Bean
    @ConditionalOnPackaging(value="war")
    public BuildCustomizer<MavenBuild> mavenWarPackagingConfigurer() {
        return build -> build.settings().packaging("war");
    }
}

