/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.code.kotlin;

import io.spring.initializr.generator.buildsystem.gradle.GradleTask;
import io.spring.initializr.generator.spring.code.kotlin.KotlinGradleBuildCustomizer;
import io.spring.initializr.generator.spring.code.kotlin.KotlinProjectSettings;
import java.util.List;
import java.util.stream.Collectors;

class GroovyDslKotlinGradleBuildCustomizer
extends KotlinGradleBuildCustomizer {
    GroovyDslKotlinGradleBuildCustomizer(KotlinProjectSettings kotlinProjectSettings) {
        super(kotlinProjectSettings);
    }

    @Override
    protected void customizeKotlinOptions(KotlinProjectSettings settings, GradleTask.Builder compile) {
        compile.nested("kotlinOptions", kotlinOptions -> {
            kotlinOptions.append("freeCompilerArgs", this.compilerArgsAsString(settings.getCompilerArgs()));
            kotlinOptions.attribute("jvmTarget", "'" + settings.getJvmTarget() + "'");
        });
    }

    private String compilerArgsAsString(List<String> compilerArgs) {
        if (compilerArgs.size() == 1) {
            return "'" + compilerArgs.get(0) + "'";
        }
        String values = compilerArgs.stream().map(arg -> "'" + arg + "'").collect(Collectors.joining(", "));
        return "[%s]".formatted(values);
    }
}

