/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.build;

import io.spring.initializr.generator.buildsystem.Build;
import io.spring.initializr.generator.buildsystem.MavenRepository;
import io.spring.initializr.generator.spring.build.BuildCustomizer;
import io.spring.initializr.generator.version.Version;

class SpringBootVersionRepositoriesBuildCustomizer
implements BuildCustomizer<Build> {
    static final MavenRepository SPRING_MILESTONES = MavenRepository.withIdAndUrl((String)"spring-milestones", (String)"https://repo.spring.io/milestone").name("Spring Milestones").onlyReleases().build();
    static final MavenRepository SPRING_SNAPSHOTS = MavenRepository.withIdAndUrl((String)"spring-snapshots", (String)"https://repo.spring.io/snapshot").name("Spring Snapshots").onlySnapshots().build();
    private final Version springBootVersion;

    SpringBootVersionRepositoriesBuildCustomizer(Version springBootVersion) {
        this.springBootVersion = springBootVersion;
    }

    @Override
    public void customize(Build build) {
        build.repositories().add((Object)"maven-central");
        switch (this.getReleaseType()) {
            case MILESTONE: {
                this.addMilestoneRepository(build);
                break;
            }
            case SNAPSHOT: {
                if (this.isMaintenanceRelease()) {
                    this.addSnapshotRepository(build);
                    break;
                }
                this.addMilestoneRepository(build);
                this.addSnapshotRepository(build);
            }
        }
    }

    private ReleaseType getReleaseType() {
        Version.Qualifier qualifier = this.springBootVersion.getQualifier();
        if (qualifier == null) {
            return ReleaseType.GA;
        }
        String id = qualifier.getId();
        if ("RELEASE".equals(id)) {
            return ReleaseType.GA;
        }
        if (id.contains("SNAPSHOT")) {
            return ReleaseType.SNAPSHOT;
        }
        return ReleaseType.MILESTONE;
    }

    private boolean isMaintenanceRelease() {
        Integer patch = this.springBootVersion.getPatch();
        return patch != null && patch > 0;
    }

    private void addSnapshotRepository(Build build) {
        build.repositories().add(SPRING_SNAPSHOTS);
        build.pluginRepositories().add(SPRING_SNAPSHOTS);
    }

    private void addMilestoneRepository(Build build) {
        build.repositories().add(SPRING_MILESTONES);
        build.pluginRepositories().add(SPRING_MILESTONES);
    }

    private static enum ReleaseType {
        GA,
        MILESTONE,
        SNAPSHOT;

    }
}

