/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.code;

import io.spring.initializr.generator.language.CompilationUnit;
import io.spring.initializr.generator.language.SourceCode;
import io.spring.initializr.generator.language.TypeDeclaration;
import io.spring.initializr.generator.spring.code.MainSourceCodeCustomizer;
import io.spring.initializr.generator.spring.code.ServletInitializerCustomizer;
import io.spring.initializr.generator.spring.util.LambdaSafe;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;

class ServletInitializerContributor
implements MainSourceCodeCustomizer<TypeDeclaration, CompilationUnit<TypeDeclaration>, SourceCode<TypeDeclaration, CompilationUnit<TypeDeclaration>>> {
    private final String packageName;
    private final String initializerClassName;
    private final ObjectProvider<ServletInitializerCustomizer<?>> servletInitializerCustomizers;

    ServletInitializerContributor(String packageName, String initializerClassName, ObjectProvider<ServletInitializerCustomizer<?>> servletInitializerCustomizers) {
        this.packageName = packageName;
        this.initializerClassName = initializerClassName;
        this.servletInitializerCustomizers = servletInitializerCustomizers;
    }

    @Override
    public void customize(SourceCode<TypeDeclaration, CompilationUnit<TypeDeclaration>> sourceCode) {
        CompilationUnit compilationUnit = sourceCode.createCompilationUnit(this.packageName, "ServletInitializer");
        TypeDeclaration servletInitializer = compilationUnit.createTypeDeclaration("ServletInitializer");
        servletInitializer.extend(this.initializerClassName);
        this.customizeServletInitializer(servletInitializer);
    }

    private void customizeServletInitializer(TypeDeclaration servletInitializer) {
        List customizers = this.servletInitializerCustomizers.orderedStream().collect(Collectors.toList());
        LambdaSafe.callbacks(ServletInitializerCustomizer.class, customizers, servletInitializer, new Object[0]).invoke(customizer -> customizer.customize(servletInitializer));
    }
}

