/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.code;

import io.spring.initializr.generator.condition.ConditionalOnPackaging;
import io.spring.initializr.generator.condition.ConditionalOnPlatformVersion;
import io.spring.initializr.generator.language.ClassName;
import io.spring.initializr.generator.language.TypeDeclaration;
import io.spring.initializr.generator.project.ProjectDescription;
import io.spring.initializr.generator.project.ProjectGenerationConfiguration;
import io.spring.initializr.generator.spring.code.MainApplicationTypeCustomizer;
import io.spring.initializr.generator.spring.code.ServletInitializerContributor;
import io.spring.initializr.generator.spring.code.ServletInitializerCustomizer;
import io.spring.initializr.generator.spring.code.TestApplicationTypeCustomizer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ProjectGenerationConfiguration
public class SourceCodeProjectGenerationConfiguration {
    @Bean
    public MainApplicationTypeCustomizer<TypeDeclaration> springBootApplicationAnnotator() {
        return typeDeclaration -> typeDeclaration.annotations().add(ClassName.of((String)"org.springframework.boot.autoconfigure.SpringBootApplication"));
    }

    @Bean
    public TestApplicationTypeCustomizer<TypeDeclaration> junitJupiterSpringBootTestTypeCustomizer() {
        return typeDeclaration -> typeDeclaration.annotations().add(ClassName.of((String)"org.springframework.boot.test.context.SpringBootTest"));
    }

    @Configuration
    @ConditionalOnPackaging(value="war")
    static class WarPackagingConfiguration {
        private final ProjectDescription description;

        WarPackagingConfiguration(ProjectDescription description) {
            this.description = description;
        }

        @Bean
        @ConditionalOnPlatformVersion(value={"2.0.0.M1"})
        ServletInitializerContributor boot20ServletInitializerContributor(ObjectProvider<ServletInitializerCustomizer<?>> servletInitializerCustomizers) {
            return new ServletInitializerContributor(this.description.getPackageName(), "org.springframework.boot.web.servlet.support.SpringBootServletInitializer", servletInitializerCustomizers);
        }
    }
}

