/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.documentation;

import io.spring.initializr.generator.io.template.MustacheTemplateRenderer;
import io.spring.initializr.generator.io.template.TemplateRenderer;
import io.spring.initializr.generator.io.text.BulletedSection;
import io.spring.initializr.generator.io.text.MustacheSection;
import io.spring.initializr.generator.io.text.Section;
import io.spring.initializr.generator.spring.documentation.GettingStartedSection;
import io.spring.initializr.generator.spring.documentation.PreDefinedSection;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class HelpDocument {
    private final MustacheTemplateRenderer templateRenderer;
    private final BulletedSection<String> warnings;
    private final GettingStartedSection gettingStarted;
    private final PreDefinedSection nextSteps;
    private final LinkedList<Section> sections = new LinkedList();

    public HelpDocument(MustacheTemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
        this.warnings = new BulletedSection((TemplateRenderer)templateRenderer, "documentation/warnings");
        this.gettingStarted = new GettingStartedSection(templateRenderer);
        this.nextSteps = new PreDefinedSection("Next Steps");
    }

    public BulletedSection<String> getWarnings() {
        return this.warnings;
    }

    public GettingStartedSection gettingStarted() {
        return this.gettingStarted;
    }

    public PreDefinedSection nextSteps() {
        return this.nextSteps;
    }

    public HelpDocument addSection(Section section) {
        this.sections.add(section);
        return this;
    }

    public HelpDocument addSection(String templateName, Map<String, Object> model) {
        return this.addSection((Section)new MustacheSection(this.templateRenderer, templateName, model));
    }

    public List<Section> getSections() {
        return Collections.unmodifiableList(this.sections);
    }

    public void write(PrintWriter writer) throws IOException {
        ArrayList<Object> allSections = new ArrayList<Object>();
        allSections.add(this.warnings);
        allSections.add(this.gettingStarted);
        allSections.addAll(this.sections);
        allSections.add(this.nextSteps);
        for (Section section : allSections) {
            section.write(writer);
        }
    }

    public boolean isEmpty() {
        return this.getWarnings().isEmpty() && this.gettingStarted().isEmpty() && this.sections.isEmpty() && this.nextSteps().isEmpty();
    }
}

