/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.properties;

import io.spring.initializr.generator.project.contributor.ProjectContributor;
import io.spring.initializr.generator.spring.properties.ApplicationProperties;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

public class ApplicationPropertiesContributor
implements ProjectContributor {
    private static final String FILE = "src/main/resources/application.properties";
    private final ApplicationProperties properties;

    public ApplicationPropertiesContributor(ApplicationProperties properties) {
        this.properties = properties;
    }

    public void contribute(Path projectRoot) throws IOException {
        Path output = projectRoot.resolve(FILE);
        if (!Files.exists(output, new LinkOption[0])) {
            Files.createDirectories(output.getParent(), new FileAttribute[0]);
            Files.createFile(output, new FileAttribute[0]);
        }
        try (PrintWriter writer = new PrintWriter(Files.newOutputStream(output, StandardOpenOption.APPEND), false, StandardCharsets.UTF_8);){
            this.properties.writeTo(writer);
        }
    }
}

