/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.test.buildsystem.maven;

import io.spring.initializr.generator.test.io.AbstractTextAssert;
import io.spring.initializr.generator.test.io.NodeAssert;
import io.spring.initializr.generator.test.io.TextTestUtils;
import io.spring.initializr.metadata.BillOfMaterials;
import io.spring.initializr.metadata.Dependency;
import io.spring.initializr.metadata.Repository;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.function.Predicate;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.Condition;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.StringAssert;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MavenBuildAssert
extends AbstractTextAssert<MavenBuildAssert> {
    private final NodeAssert pom;

    public MavenBuildAssert(String content) {
        super(content, MavenBuildAssert.class);
        this.pom = new NodeAssert(content);
    }

    public MavenBuildAssert(Path pomFile) {
        this(TextTestUtils.readContent(pomFile));
    }

    public MavenBuildAssert hasParent(String groupId, String artifactId, String version) {
        return this.hasText("/project/parent/groupId", groupId).hasText("/project/parent/artifactId", artifactId).hasText("/project/parent/version", version);
    }

    public MavenBuildAssert hasGroupId(String groupId) {
        return this.hasText("/project/groupId", groupId);
    }

    public MavenBuildAssert hasArtifactId(String artifactId) {
        return this.hasText("/project/artifactId", artifactId);
    }

    public MavenBuildAssert hasVersion(String version) {
        return this.hasText("/project/version", version);
    }

    public MavenBuildAssert hasPackaging(String packaging) {
        return this.hasText("/project/packaging", packaging);
    }

    public MavenBuildAssert hasName(String name) {
        return this.hasText("/project/name", name);
    }

    public MavenBuildAssert hasDescription(String description) {
        return this.hasText("/project/description", description);
    }

    public MavenBuildAssert hasProperty(String name, String value) {
        return this.hasText("/project/properties/" + name, value);
    }

    public MavenBuildAssert doesNotHaveProperty(String name) {
        return this.doesNotHaveNode("/project/properties/" + name);
    }

    public MavenBuildAssert hasDependenciesSize(int size) {
        this.pom.nodesAtPath("project/dependencies/dependency").hasSize(size);
        return this;
    }

    public MavenBuildAssert hasDependency(String groupId, String artifactId) {
        return this.hasDependency(groupId, artifactId, null);
    }

    public MavenBuildAssert hasDependency(String groupId, String artifactId, String version) {
        return this.hasDependency(Dependency.create((String)groupId, (String)artifactId, (String)version, (String)"compile"));
    }

    public MavenBuildAssert hasDependency(String groupId, String artifactId, String version, String scope) {
        return this.hasDependency(Dependency.create((String)groupId, (String)artifactId, (String)version, (String)scope));
    }

    public MavenBuildAssert hasDependency(Dependency dependency) {
        this.pom.nodesAtPath("/project/dependencies/dependency").areExactly(1, new Condition(candidate -> {
            Dependency actual = MavenBuildAssert.toDependency(candidate);
            if (dependency.getGroupId().equals(actual.getGroupId()) && dependency.getArtifactId().equals(actual.getArtifactId())) {
                if (dependency.getVersion() != null && !dependency.getVersion().equals(actual.getVersion())) {
                    return false;
                }
                if (dependency.getScope() != null && !dependency.getScope().equals(actual.getScope())) {
                    return false;
                }
                return dependency.getType() == null || dependency.getType().equals(actual.getType());
            }
            return false;
        }, "matching dependency", new Object[0]));
        return this;
    }

    public MavenBuildAssert doesNotHaveDependency(String groupId, String artifactId) {
        this.pom.nodesAtPath("/project/dependencies/dependency").noneMatch(candidate -> {
            Dependency actual = MavenBuildAssert.toDependency(candidate);
            return groupId.equals(actual.getGroupId()) && artifactId.equals(actual.getArtifactId());
        });
        return this;
    }

    public MavenBuildAssert hasBomsSize(int size) {
        this.pom.nodesAtPath("/project/dependencyManagement/dependencies/dependency").hasSize(size);
        return this;
    }

    public MavenBuildAssert hasBom(String groupId, String artifactId, String version) {
        this.pom.nodesAtPath("/project/dependencyManagement/dependencies/dependency").areExactly(1, new Condition(candidate -> {
            BillOfMaterials actual = MavenBuildAssert.toBom(candidate);
            return actual != null && actual.getGroupId().equals(groupId) && actual.getArtifactId().equals(artifactId) && actual.getVersion().equals(version);
        }, "matching bom", new Object[0]));
        return this;
    }

    public MavenBuildAssert doesNotHaveBom(String groupId, String artifactId) {
        this.pom.nodesAtPath("/project/dependencyManagement/dependencies/dependency").noneMatch(candidate -> {
            BillOfMaterials actual = MavenBuildAssert.toBom(candidate);
            return groupId.equals(actual.getGroupId()) && artifactId.equals(actual.getArtifactId());
        });
        return this;
    }

    public MavenBuildAssert hasRepositoriesSize(int size) {
        this.pom.nodesAtPath("/project/repositories/repository").hasSize(size);
        return this;
    }

    public MavenBuildAssert hasRepository(String id, String name, String url, Boolean snapshotsEnabled) {
        this.pom.nodesAtPath("/project/repositories/repository").areExactly(1, new Condition(candidate -> {
            String actualId = ((Element)candidate).getElementsByTagName("id").item(0).getTextContent();
            if (actualId.equals(id)) {
                Repository repository = MavenBuildAssert.toRepository(candidate);
                if (name != null) {
                    new StringAssert(repository.getName()).isEqualTo(name);
                }
                if (url != null) {
                    ((ObjectAssert)new ObjectAssert((Object)repository.getUrl()).describedAs("URL of repository " + id, new Object[0])).isNotNull();
                    new StringAssert(repository.getUrl().toExternalForm()).isEqualTo(url);
                }
                if (snapshotsEnabled.booleanValue()) {
                    new BooleanAssert(Boolean.valueOf(repository.isSnapshotsEnabled())).isEqualTo((Object)snapshotsEnabled);
                }
                return true;
            }
            return false;
        }, "matching repository", new Object[0]));
        return this;
    }

    public MavenBuildAssert hasProfile(String id) {
        this.pom.nodesAtPath("/project/profiles/profile").areExactly(1, new Condition(MavenBuildAssert.profile(id), "matching profile", new Object[0]));
        return this;
    }

    public MavenBuildAssert doesNotHaveProfile(String id) {
        this.pom.nodesAtPath("/project/profiles/profile").noneMatch(MavenBuildAssert.profile(id));
        return this;
    }

    public MavenBuildAssert doesNotHaveNode(String path) {
        this.pom.nodeAtPath(path).isNull();
        return this;
    }

    public MavenBuildAssert hasText(String path, String value) {
        this.pom.textAtPath(path).isEqualTo(value);
        return this;
    }

    private static Dependency toDependency(Node item) {
        if (item instanceof Element) {
            NodeList type;
            NodeList scope;
            NodeList version;
            NodeList artifactId;
            Dependency dependency = new Dependency();
            Element element = (Element)item;
            NodeList groupId = element.getElementsByTagName("groupId");
            if (groupId.getLength() > 0) {
                dependency.setGroupId(groupId.item(0).getTextContent());
            }
            if ((artifactId = element.getElementsByTagName("artifactId")).getLength() > 0) {
                dependency.setArtifactId(artifactId.item(0).getTextContent());
            }
            if ((version = element.getElementsByTagName("version")).getLength() > 0) {
                dependency.setVersion(version.item(0).getTextContent());
            }
            if ((scope = element.getElementsByTagName("scope")).getLength() > 0) {
                dependency.setScope(scope.item(0).getTextContent());
            }
            if ((type = element.getElementsByTagName("type")).getLength() > 0) {
                dependency.setType(type.item(0).getTextContent());
            }
            return dependency;
        }
        return null;
    }

    private static BillOfMaterials toBom(Node item) {
        NodeList scope;
        Element element;
        NodeList type;
        if (item instanceof Element && MavenBuildAssert.isBom(type = (element = (Element)item).getElementsByTagName("type"), scope = element.getElementsByTagName("scope"))) {
            NodeList version;
            NodeList artifactId;
            BillOfMaterials bom = new BillOfMaterials();
            NodeList groupId = element.getElementsByTagName("groupId");
            if (groupId.getLength() > 0) {
                bom.setGroupId(groupId.item(0).getTextContent());
            }
            if ((artifactId = element.getElementsByTagName("artifactId")).getLength() > 0) {
                bom.setArtifactId(artifactId.item(0).getTextContent());
            }
            if ((version = element.getElementsByTagName("version")).getLength() > 0) {
                bom.setVersion(version.item(0).getTextContent());
            }
            return bom;
        }
        return null;
    }

    private static boolean isBom(NodeList type, NodeList scope) {
        if (type.getLength() == 0 || scope.getLength() == 0) {
            return false;
        }
        String typeValue = type.item(0).getTextContent();
        String scopeValue = scope.item(0).getTextContent();
        return "pom".equals(typeValue) && "import".equals(scopeValue);
    }

    private static Repository toRepository(Node item) {
        Element snapshotsElement;
        NodeList snapshotsEnabled;
        NodeList snapshots;
        Element releasesElement;
        NodeList releasesEnabled;
        NodeList releases;
        NodeList url;
        Repository repository = new Repository();
        Element element = (Element)item;
        NodeList name = element.getElementsByTagName("name");
        if (name.getLength() > 0) {
            repository.setName(name.item(0).getTextContent());
        }
        if ((url = element.getElementsByTagName("url")).getLength() > 0) {
            try {
                repository.setUrl(new URL(url.item(0).getTextContent()));
            }
            catch (MalformedURLException | DOMException ex) {
                throw new IllegalStateException("Cannot parse URL", ex);
            }
        }
        if ((releases = element.getElementsByTagName("releases")).getLength() > 0 && (releasesEnabled = (releasesElement = (Element)releases.item(0)).getElementsByTagName("enabled")).getLength() > 0) {
            repository.setReleasesEnabled("true".equals(releasesEnabled.item(0).getTextContent()));
        }
        if ((snapshots = element.getElementsByTagName("snapshots")).getLength() > 0 && (snapshotsEnabled = (snapshotsElement = (Element)snapshots.item(0)).getElementsByTagName("enabled")).getLength() > 0) {
            repository.setSnapshotsEnabled("true".equals(snapshotsEnabled.item(0).getTextContent()));
        }
        return repository;
    }

    private static Predicate<? super Node> profile(String id) {
        return candidate -> {
            String actualId = ((Element)candidate).getElementsByTagName("id").item(0).getTextContent();
            return actualId.equals(id);
        };
    }
}

