/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.test.io;

import io.spring.initializr.generator.test.io.TextTestUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.ListAssert;
import org.springframework.core.io.Resource;
import org.springframework.util.StreamUtils;

public abstract class AbstractTextAssert<SELF extends AbstractStringAssert<SELF>>
extends AbstractStringAssert<SELF> {
    protected AbstractTextAssert(String actual, Class<?> selfType) {
        super(actual, selfType);
    }

    protected AbstractTextAssert(Path textFile, Class<?> selfType) {
        this(TextTestUtils.readContent(textFile), selfType);
        this.info.description("Content at " + textFile, new Object[0]);
    }

    public SELF hasSameContentAs(Resource expected) {
        if (!expected.isReadable()) {
            this.failWithMessage("Expected resource does not exist: " + expected, new Object[0]);
        }
        try (InputStream in = expected.getInputStream();){
            String expectedContent = StreamUtils.copyToString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            this.isEqualToIgnoringNewLines(expectedContent);
        }
        catch (IOException ex) {
            this.failWithMessage("Cannot read expected content " + expected, new Object[0]);
        }
        return (SELF)((AbstractStringAssert)this.myself);
    }

    public SELF containsExactly(String ... lines) {
        this.lines().containsExactly((Object[])lines);
        return (SELF)((AbstractStringAssert)this.myself);
    }

    public ListAssert<String> lines() {
        return new ListAssert(TextTestUtils.readAllLines((String)this.actual));
    }
}

