/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.test.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.springframework.util.StreamUtils;

public final class TextTestUtils {
    private TextTestUtils() {
    }

    public static List<String> readAllLines(String source) {
        String[] lines = source.split("\\r?\\n");
        return Arrays.asList(lines);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readContent(Path source) {
        Assertions.assertThat((Path)source).isRegularFile();
        try (InputStream stream = Files.newInputStream(source, new OpenOption[0]);){
            String string = StreamUtils.copyToString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

