/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.test.project;

import io.spring.initializr.generator.language.Language;
import io.spring.initializr.generator.language.SourceStructure;
import io.spring.initializr.generator.test.io.TextAssert;
import io.spring.initializr.generator.test.project.AbstractProjectAssert;
import java.nio.file.Path;
import org.assertj.core.api.PathAssert;
import org.springframework.util.StringUtils;

public abstract class AbstractJvmModuleAssert<SELF extends AbstractJvmModuleAssert<SELF>>
extends AbstractProjectAssert<SELF> {
    private final SourceStructure mainDirectory;
    private final SourceStructure testDirectory;
    private final String sourceFileExtension;

    protected AbstractJvmModuleAssert(Path projectDirectory, Language language, Class<?> selfType) {
        super(projectDirectory, selfType);
        this.mainDirectory = new SourceStructure(projectDirectory.resolve("src/main/"), language);
        this.testDirectory = new SourceStructure(projectDirectory.resolve("src/test/"), language);
        this.sourceFileExtension = language.sourceFileExtension();
    }

    public SELF hasMainPackage(String packageName) {
        return this.hasPackage(this.mainDirectory.getSourcesDirectory(), packageName);
    }

    public SELF hasMainSource(String packageName, String name) {
        this.validateAndGetAsset(this.mainDirectory.getSourcesDirectory(), packageName, name);
        return (SELF)((Object)((AbstractJvmModuleAssert)this.myself));
    }

    public TextAssert mainSource(String packageName, String name) {
        return new TextAssert(this.validateAndGetAsset(this.mainDirectory.getSourcesDirectory(), packageName, name));
    }

    public SELF hasMainResource(String resourcePath) {
        return this.hasResource(this.mainDirectory.getRootDirectory().resolve("resources"), resourcePath);
    }

    public SELF hasTestPackage(String packageName) {
        return this.hasPackage(this.testDirectory.getSourcesDirectory(), packageName);
    }

    public SELF hasTestSource(String packageName, String name) {
        this.validateAndGetAsset(this.testDirectory.getSourcesDirectory(), packageName, name);
        return (SELF)((Object)((AbstractJvmModuleAssert)this.myself));
    }

    public TextAssert testSource(String packageName, String name) {
        return new TextAssert(this.validateAndGetAsset(this.testDirectory.getSourcesDirectory(), packageName, name));
    }

    private SELF hasPackage(Path baseDir, String packageName) {
        Path expected = baseDir.resolve(AbstractJvmModuleAssert.packageToPath(packageName));
        ((PathAssert)new PathAssert(expected).exists()).isDirectory();
        return (SELF)((Object)((AbstractJvmModuleAssert)this.myself));
    }

    private Path validateAndGetAsset(Path baseDir, String packageName, String name) {
        Path source = this.resolveSource(baseDir, packageName, name);
        ((PathAssert)((PathAssert)new PathAssert(source).as("Source '%s.%s' not found in package '%s'", new Object[]{name, this.sourceFileExtension, packageName})).exists()).isRegularFile();
        return source;
    }

    private SELF hasResource(Path baseDir, String relativePath) {
        Path path = baseDir.resolve(relativePath);
        ((PathAssert)((PathAssert)new PathAssert(path).as("Resource '%s' not found", new Object[]{relativePath})).exists()).isRegularFile();
        return (SELF)((Object)((AbstractJvmModuleAssert)this.myself));
    }

    private Path resolveSource(Path baseDir, String packageName, String name) {
        return baseDir.resolve(this.createSourceRelativePath(packageName, name));
    }

    private String createSourceRelativePath(String packageName, String name) {
        return AbstractJvmModuleAssert.packageToPath(packageName) + "/" + name + "." + this.sourceFileExtension;
    }

    private static String packageToPath(String packageName) {
        String packagePath = packageName.replace(".", "/");
        return StringUtils.trimTrailingCharacter((String)packagePath, (char)'/');
    }
}

