/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.test.project;

import io.spring.initializr.generator.test.io.TextAssert;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.AbstractPathAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.PathAssert;

public abstract class AbstractProjectAssert<SELF extends AbstractProjectAssert<SELF>>
extends AbstractPathAssert<SELF> {
    private ListAssert<String> filesAssert;

    protected AbstractProjectAssert(Path projectDirectory, Class<?> selfType) {
        super(projectDirectory, selfType);
    }

    public SELF containsDirectories(String ... directoryPaths) {
        for (String directory : directoryPaths) {
            ((PathAssert)new PathAssert(((Path)this.actual).resolve(directory)).exists()).isDirectory();
        }
        return (SELF)((Object)((AbstractProjectAssert)this.myself));
    }

    public SELF doesNotContainDirectories(String ... directoryPaths) {
        for (String directory : directoryPaths) {
            new PathAssert(((Path)this.actual).resolve(directory)).doesNotExist();
        }
        return (SELF)((Object)((AbstractProjectAssert)this.myself));
    }

    public SELF containsFiles(String ... filePaths) {
        this.filePaths().contains((Object[])filePaths);
        return (SELF)((Object)((AbstractProjectAssert)this.myself));
    }

    public SELF doesNotContainFiles(String ... filePaths) {
        this.filePaths().doesNotContain((Object[])filePaths);
        return (SELF)((Object)((AbstractProjectAssert)this.myself));
    }

    public ListAssert<String> filePaths() {
        if (this.filesAssert == null) {
            this.filesAssert = new ListAssert(this.getRelativePathsOfProjectFiles());
        }
        return this.filesAssert;
    }

    public PathAssert file(String path) {
        Path file = ((Path)this.actual).resolve(path);
        return (PathAssert)((PathAssert)new PathAssert(file).exists()).isRegularFile();
    }

    public TextAssert textFile(String path) {
        Path file = ((Path)this.actual).resolve(path);
        ((PathAssert)new PathAssert(file).exists()).isRegularFile();
        return new TextAssert(file);
    }

    private List<String> getRelativePathsOfProjectFiles() {
        final ArrayList<String> relativePaths = new ArrayList<String>();
        try {
            Files.walkFileTree((Path)this.actual, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    relativePaths.add(AbstractProjectAssert.this.createRelativePath(file));
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return relativePaths;
    }

    private String createRelativePath(Path file) {
        String relativePath = ((Path)this.actual).relativize(file).toString();
        if (FileSystems.getDefault().getSeparator().equals("\\")) {
            return relativePath.replace('\\', '/');
        }
        return relativePath;
    }
}

