/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.test.project;

import io.spring.initializr.generator.io.IndentingWriterFactory;
import io.spring.initializr.generator.io.SimpleIndentStrategy;
import io.spring.initializr.generator.project.MutableProjectDescription;
import io.spring.initializr.generator.project.ProjectDirectoryFactory;
import io.spring.initializr.generator.project.ProjectGenerationContext;
import io.spring.initializr.generator.project.ProjectGenerationException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;

public abstract class AbstractProjectGenerationTester<SELF extends AbstractProjectGenerationTester<SELF>> {
    private final Map<Class<?>, Supplier<?>> beanDefinitions;
    private final Consumer<ProjectGenerationContext> contextInitializer;
    private final Consumer<MutableProjectDescription> descriptionCustomizer;

    protected AbstractProjectGenerationTester(Map<Class<?>, Supplier<?>> beanDefinitions, Consumer<ProjectGenerationContext> contextInitializer, Consumer<MutableProjectDescription> descriptionCustomizer) {
        this.beanDefinitions = new LinkedHashMap(beanDefinitions);
        this.descriptionCustomizer = descriptionCustomizer;
        this.contextInitializer = contextInitializer;
    }

    protected AbstractProjectGenerationTester() {
        this(Collections.emptyMap(), AbstractProjectGenerationTester.emptyContextInitializer(), AbstractProjectGenerationTester.defaultDescriptionCustomizer());
    }

    private static Consumer<ProjectGenerationContext> emptyContextInitializer() {
        return context -> {};
    }

    private static Consumer<MutableProjectDescription> defaultDescriptionCustomizer() {
        return projectDescription -> {
            if (projectDescription.getGroupId() == null) {
                projectDescription.setGroupId("com.example");
            }
            if (projectDescription.getArtifactId() == null) {
                projectDescription.setArtifactId("demo");
            }
            if (projectDescription.getVersion() == null) {
                projectDescription.setVersion("0.0.1-SNAPSHOT");
            }
            if (projectDescription.getApplicationName() == null) {
                projectDescription.setApplicationName("DemoApplication");
            }
        };
    }

    protected abstract SELF newInstance(Map<Class<?>, Supplier<?>> var1, Consumer<ProjectGenerationContext> var2, Consumer<MutableProjectDescription> var3);

    public <T> SELF withBean(Class<T> beanType, Supplier<T> beanDefinition) {
        LinkedHashMap beans = new LinkedHashMap(this.beanDefinitions);
        beans.put(beanType, beanDefinition);
        return this.newInstance(beans, this.contextInitializer, this.descriptionCustomizer);
    }

    public SELF withDirectory(Path directory) {
        return this.withBean(ProjectDirectoryFactory.class, () -> description -> Files.createTempDirectory(directory, "project-", new FileAttribute[0]));
    }

    public SELF withIndentingWriterFactory() {
        return this.withBean(IndentingWriterFactory.class, () -> IndentingWriterFactory.create((Function)new SimpleIndentStrategy("    ")));
    }

    public SELF withConfiguration(Class<?> ... configurationClasses) {
        return this.withContextInitializer(context -> context.register(configurationClasses));
    }

    public SELF withContextInitializer(Consumer<ProjectGenerationContext> context) {
        return this.newInstance(this.beanDefinitions, this.contextInitializer.andThen(context), this.descriptionCustomizer);
    }

    public SELF withDescriptionCustomizer(Consumer<MutableProjectDescription> description) {
        return this.newInstance(this.beanDefinitions, this.contextInitializer, this.descriptionCustomizer.andThen(description));
    }

    protected <T> T invokeProjectGeneration(MutableProjectDescription description, ProjectGenerationInvoker<T> invoker) {
        this.descriptionCustomizer.accept(description);
        try {
            return invoker.generate(this.beansConfigurer().andThen(this.contextInitializer));
        }
        catch (IOException ex) {
            throw new ProjectGenerationException("Failed to generated project", (Throwable)ex);
        }
    }

    private Consumer<ProjectGenerationContext> beansConfigurer() {
        return context -> this.beanDefinitions.forEach((type, definition) -> this.register((ProjectGenerationContext)context, (Class)type, definition.get()));
    }

    private <T> void register(ProjectGenerationContext context, Class<T> type, Object instance) {
        Object bean = type.cast(instance);
        context.registerBean(type, () -> bean, new BeanDefinitionCustomizer[0]);
    }

    protected static interface ProjectGenerationInvoker<T> {
        public T generate(Consumer<ProjectGenerationContext> var1) throws IOException;
    }
}

