/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.test.project;

import io.spring.initializr.generator.project.MutableProjectDescription;
import io.spring.initializr.generator.project.ProjectAssetGenerator;
import io.spring.initializr.generator.project.ProjectDescription;
import io.spring.initializr.generator.project.ProjectDirectoryFactory;
import io.spring.initializr.generator.project.ProjectGenerationContext;
import io.spring.initializr.generator.project.contributor.ProjectContributor;
import io.spring.initializr.generator.test.project.AbstractProjectGenerationTester;
import io.spring.initializr.generator.test.project.ProjectStructure;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.test.context.assertj.AssertableApplicationContext;
import org.springframework.boot.test.context.runner.ApplicationContextRunner;
import org.springframework.boot.test.context.runner.ContextConsumer;

public class ProjectAssetTester
extends AbstractProjectGenerationTester<ProjectAssetTester> {
    public ProjectAssetTester() {
    }

    private ProjectAssetTester(Map<Class<?>, Supplier<?>> beanDefinitions, Consumer<ProjectGenerationContext> contextInitializer, Consumer<MutableProjectDescription> descriptionCustomizer) {
        super(beanDefinitions, contextInitializer, descriptionCustomizer);
    }

    @Override
    protected ProjectAssetTester newInstance(Map<Class<?>, Supplier<?>> beanDefinitions, Consumer<ProjectGenerationContext> contextInitializer, Consumer<MutableProjectDescription> descriptionCustomizer) {
        return new ProjectAssetTester(beanDefinitions, contextInitializer, descriptionCustomizer);
    }

    public void configure(MutableProjectDescription description, ContextConsumer<AssertableApplicationContext> consumer) {
        this.invokeProjectGeneration(description, contextInitializer -> {
            ((ApplicationContextRunner)new ApplicationContextRunner(ProjectGenerationContext::new).withInitializer(ctx -> {
                ProjectGenerationContext projectGenerationContext = (ProjectGenerationContext)ctx;
                projectGenerationContext.registerBean(ProjectDescription.class, () -> description, new BeanDefinitionCustomizer[0]);
                contextInitializer.accept(projectGenerationContext);
            })).run(consumer);
            return null;
        });
    }

    public <T> T generate(MutableProjectDescription description, ProjectAssetGenerator<T> projectAssetGenerator) {
        return (T)this.invokeProjectGeneration(description, contextInitializer -> {
            try (ProjectGenerationContext context = new ProjectGenerationContext();){
                context.registerBean(ProjectDescription.class, () -> description, new BeanDefinitionCustomizer[0]);
                contextInitializer.accept(context);
                context.refresh();
                Object object = projectAssetGenerator.generate(context);
                return object;
            }
        });
    }

    public ProjectStructure generate(MutableProjectDescription description) {
        return this.generate(description, this.runAllAvailableContributors());
    }

    private ProjectAssetGenerator<ProjectStructure> runAllAvailableContributors() {
        return context -> {
            Path projectDirectory = ((ProjectDirectoryFactory)context.getBean(ProjectDirectoryFactory.class)).createProjectDirectory((ProjectDescription)context.getBean(ProjectDescription.class));
            List projectContributors = context.getBeanProvider(ProjectContributor.class).orderedStream().collect(Collectors.toList());
            for (ProjectContributor projectContributor : projectContributors) {
                projectContributor.contribute(projectDirectory);
            }
            return new ProjectStructure(projectDirectory);
        };
    }
}

