/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.test.project;

import io.spring.initializr.generator.test.project.ModuleAssert;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.assertj.core.api.AssertProvider;

public final class ProjectStructure
implements AssertProvider<ModuleAssert> {
    private final Path projectDirectory;

    public ProjectStructure(Path projectDirectory) {
        this.projectDirectory = projectDirectory;
    }

    public ModuleAssert assertThat() {
        return new ModuleAssert(this.getProjectDirectory());
    }

    public Path getProjectDirectory() {
        return this.projectDirectory;
    }

    public ProjectStructure resolveModule(String name) {
        Path projectDir = this.projectDirectory.resolve(name);
        if (!Files.isDirectory(projectDir, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("No directory '%s' found in '%s'", name, this.projectDirectory));
        }
        return new ProjectStructure(projectDir);
    }
}

