/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem;

import io.spring.initializr.generator.buildsystem.DependencyScope;
import io.spring.initializr.generator.version.VersionReference;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.springframework.util.Assert;

public class Dependency {
    private final String groupId;
    private final String artifactId;
    private final VersionReference version;
    private final DependencyScope scope;
    private final String classifier;
    private final String type;
    private final Set<Exclusion> exclusions;

    protected Dependency(Builder<?> builder) {
        this.groupId = ((Builder)builder).groupId;
        this.artifactId = ((Builder)builder).artifactId;
        this.version = ((Builder)builder).version;
        this.scope = ((Builder)builder).scope;
        this.classifier = ((Builder)builder).classifier;
        this.type = ((Builder)builder).type;
        this.exclusions = new LinkedHashSet<Exclusion>(((Builder)builder).exclusions);
    }

    public static Builder<?> withCoordinates(String groupId, String artifactId) {
        return new Builder(groupId, artifactId);
    }

    public static Builder<?> from(Dependency dependency) {
        return new Builder(dependency.getGroupId(), dependency.getArtifactId()).initialize(dependency);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public VersionReference getVersion() {
        return this.version;
    }

    public DependencyScope getScope() {
        return this.scope;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getType() {
        return this.type;
    }

    public Set<Exclusion> getExclusions() {
        return this.exclusions;
    }

    public static final class Exclusion {
        private final String groupId;
        private final String artifactId;

        public Exclusion(String groupId, String artifactId) {
            Assert.hasText((String)groupId, (String)"GroupId must not be null");
            Assert.hasText((String)groupId, (String)"ArtifactId must not be null");
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Exclusion exclusion = (Exclusion)o;
            return this.groupId.equals(exclusion.groupId) && this.artifactId.equals(exclusion.artifactId);
        }

        public int hashCode() {
            return Objects.hash(this.groupId, this.artifactId);
        }
    }

    public static class Builder<B extends Builder<B>> {
        private String groupId;
        private String artifactId;
        private VersionReference version;
        private DependencyScope scope;
        private String type;
        private String classifier;
        private Set<Exclusion> exclusions = new LinkedHashSet<Exclusion>();

        protected Builder(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        public B groupId(String groupId) {
            this.groupId = groupId;
            return this.self();
        }

        public B artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this.self();
        }

        public B version(VersionReference version) {
            this.version = version;
            return this.self();
        }

        public B scope(DependencyScope scope) {
            this.scope = scope;
            return this.self();
        }

        public B classifier(String classifier) {
            this.classifier = classifier;
            return this.self();
        }

        public B type(String type) {
            this.type = type;
            return this.self();
        }

        public B exclusions(Exclusion ... exclusions) {
            this.exclusions = new LinkedHashSet<Exclusion>(Arrays.asList(exclusions));
            return this.self();
        }

        public B exclusions(Set<Exclusion> exclusions) {
            this.exclusions = exclusions != null ? new LinkedHashSet<Exclusion>(exclusions) : new LinkedHashSet();
            return this.self();
        }

        protected B self() {
            return (B)this;
        }

        protected B initialize(Dependency dependency) {
            ((Builder)((Builder)((Builder)((Builder)this.version(dependency.getVersion())).scope(dependency.getScope())).classifier(dependency.getClassifier())).type(dependency.getType())).exclusions(dependency.getExclusions());
            return this.self();
        }

        public Dependency build() {
            return new Dependency(this);
        }
    }
}

