/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem;

public class MavenRepository {
    public static final MavenRepository MAVEN_CENTRAL = MavenRepository.withIdAndUrl("maven-central", "https://repo.maven.apache.org/maven2").name("Maven Central").build();
    private final String id;
    private final String name;
    private final String url;
    private final boolean snapshotsEnabled;

    protected MavenRepository(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.url = builder.url;
        this.snapshotsEnabled = builder.snapshotsEnabled;
    }

    public static Builder withIdAndUrl(String id, String url) {
        return new Builder(id, url);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isSnapshotsEnabled() {
        return this.snapshotsEnabled;
    }

    public static class Builder {
        private String id;
        private String name;
        private String url;
        private boolean snapshotsEnabled;

        public Builder(String id, String url) {
            this.id = id;
            this.name = id;
            this.url = url;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder snapshotsEnabled(boolean snapshotsEnabled) {
            this.snapshotsEnabled = snapshotsEnabled;
            return this;
        }

        public MavenRepository build() {
            return new MavenRepository(this);
        }
    }
}

