/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem.gradle;

import io.spring.initializr.generator.buildsystem.MavenRepository;
import io.spring.initializr.generator.buildsystem.gradle.GradleBuild;
import io.spring.initializr.generator.io.IndentingWriter;

public abstract class GradleSettingsWriter {
    public final void writeTo(IndentingWriter writer, GradleBuild build) {
        this.writePluginManagement(writer, build);
        writer.println("rootProject.name = " + this.wrapWithQuotes(build.getSettings().getArtifact()));
    }

    private void writePluginManagement(IndentingWriter writer, GradleBuild build) {
        if (build.pluginRepositories().isEmpty()) {
            return;
        }
        writer.println("pluginManagement {");
        writer.indented(() -> this.writeRepositories(writer, build));
        writer.println("}");
    }

    private void writeRepositories(IndentingWriter writer, GradleBuild build) {
        writer.println("repositories {");
        writer.indented(() -> {
            build.pluginRepositories().items().map(this::repositoryAsString).forEach(writer::println);
            writer.println("gradlePluginPortal()");
        });
        writer.println("}");
    }

    private String repositoryAsString(MavenRepository repository) {
        if (MavenRepository.MAVEN_CENTRAL.equals(repository)) {
            return "mavenCentral()";
        }
        return "maven { " + this.urlAssignment(repository.getUrl()) + " }";
    }

    protected abstract String wrapWithQuotes(String var1);

    protected abstract String urlAssignment(String var1);
}

