/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.io;

import io.spring.initializr.generator.io.SimpleIndentStrategy;
import java.io.IOException;
import java.io.Writer;
import java.util.function.Function;

public class IndentingWriter
extends Writer {
    private final Writer out;
    private final Function<Integer, String> indentStrategy;
    private int level = 0;
    private String indent = "";
    private boolean prependIndent = false;

    public IndentingWriter(Writer out) {
        this(out, new SimpleIndentStrategy("    "));
    }

    public IndentingWriter(Writer out, Function<Integer, String> indentStrategy) {
        this.out = out;
        this.indentStrategy = indentStrategy;
    }

    public void print(String string) {
        this.write(string.toCharArray(), 0, string.length());
    }

    public void println(String string) {
        this.write(string.toCharArray(), 0, string.length());
        this.println();
    }

    public void println() {
        String separator = System.lineSeparator();
        try {
            this.out.write(separator.toCharArray(), 0, separator.length());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        this.prependIndent = true;
    }

    public void indented(Runnable runnable) {
        this.indent();
        runnable.run();
        this.outdent();
    }

    private void indent() {
        ++this.level;
        this.refreshIndent();
    }

    private void outdent() {
        --this.level;
        this.refreshIndent();
    }

    private void refreshIndent() {
        this.indent = this.indentStrategy.apply(this.level);
    }

    @Override
    public void write(char[] chars, int offset, int length) {
        try {
            if (this.prependIndent) {
                this.out.write(this.indent.toCharArray(), 0, this.indent.length());
                this.prependIndent = false;
            }
            this.out.write(chars, offset, length);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

