/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem.gradle;

import io.spring.initializr.generator.buildsystem.BillOfMaterials;
import io.spring.initializr.generator.buildsystem.Dependency;
import io.spring.initializr.generator.buildsystem.MavenRepository;
import io.spring.initializr.generator.buildsystem.gradle.GradleBuild;
import io.spring.initializr.generator.buildsystem.gradle.GradleBuildSettings;
import io.spring.initializr.generator.buildsystem.gradle.GradleBuildWriter;
import io.spring.initializr.generator.buildsystem.gradle.GradleConfiguration;
import io.spring.initializr.generator.buildsystem.gradle.GradleConfigurationContainer;
import io.spring.initializr.generator.buildsystem.gradle.GradlePlugin;
import io.spring.initializr.generator.buildsystem.gradle.GradleTask;
import io.spring.initializr.generator.buildsystem.gradle.GradleTaskContainer;
import io.spring.initializr.generator.buildsystem.gradle.StandardGradlePlugin;
import io.spring.initializr.generator.io.IndentingWriter;
import io.spring.initializr.generator.version.VersionProperty;
import io.spring.initializr.generator.version.VersionReference;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class GroovyDslGradleBuildWriter
extends GradleBuildWriter {
    @Override
    protected void writeBuildscript(IndentingWriter writer, GradleBuild build) {
        List<String> dependencies = build.getBuildscript().getDependencies();
        Map<String, String> ext = build.getBuildscript().getExt();
        if (dependencies.isEmpty() && ext.isEmpty()) {
            return;
        }
        writer.println("buildscript {");
        writer.indented(() -> {
            this.writeBuildscriptExt(writer, build);
            this.writeBuildscriptRepositories(writer, build);
            this.writeBuildscriptDependencies(writer, build);
        });
        writer.println("}");
        writer.println();
    }

    private void writeBuildscriptExt(IndentingWriter writer, GradleBuild build) {
        this.writeNestedMap(writer, "ext", build.getBuildscript().getExt(), (key, value) -> key + " = " + value);
    }

    private void writeBuildscriptRepositories(IndentingWriter writer, GradleBuild build) {
        this.writeRepositories(writer, build);
    }

    private void writeBuildscriptDependencies(IndentingWriter writer, GradleBuild build) {
        this.writeNestedCollection(writer, "dependencies", build.getBuildscript().getDependencies(), dependency -> "classpath '" + dependency + "'");
    }

    @Override
    protected void writePlugins(IndentingWriter writer, GradleBuild build) {
        this.writeNestedCollection(writer, "plugins", this.extractStandardPlugin(build), this::pluginAsString);
        this.writeCollection(writer, this.extractApplyPlugins(build), plugin -> "apply plugin: '" + plugin.getId() + "'", writer::println);
        writer.println();
    }

    private List<GradlePlugin> extractApplyPlugins(GradleBuild build) {
        return build.plugins().values().filter(GradlePlugin::isApply).collect(Collectors.toList());
    }

    private String pluginAsString(StandardGradlePlugin plugin) {
        String string = "id '" + plugin.getId() + "'";
        if (plugin.getVersion() != null) {
            string = string + " version '" + plugin.getVersion() + "'";
        }
        return string;
    }

    @Override
    protected void writeJavaSourceCompatibility(IndentingWriter writer, GradleBuildSettings settings) {
        this.writeProperty(writer, "sourceCompatibility", settings.getSourceCompatibility());
    }

    @Override
    protected String repositoryAsString(MavenRepository repository) {
        if (MavenRepository.MAVEN_CENTRAL.equals(repository)) {
            return "mavenCentral()";
        }
        return "maven { url '" + repository.getUrl() + "' }";
    }

    @Override
    protected void writeExtraProperties(IndentingWriter writer, Map<String, String> allProperties) {
        this.writeNestedCollection(writer, "ext", allProperties.entrySet(), e -> this.getFormattedExtraProperty((String)e.getKey(), (String)e.getValue()), writer::println);
    }

    private String getFormattedExtraProperty(String key, String value) {
        return String.format("set('%s', %s)", key, value);
    }

    @Override
    protected void writeConfigurations(IndentingWriter writer, GradleConfigurationContainer configurations) {
        if (configurations.isEmpty()) {
            return;
        }
        writer.println("configurations {");
        writer.indented(() -> {
            configurations.names().forEach(writer::println);
            configurations.customizations().forEach(configuration -> this.writeConfiguration(writer, (GradleConfiguration)configuration));
        });
        writer.println("}");
        writer.println("");
    }

    protected void writeConfiguration(IndentingWriter writer, GradleConfiguration configuration) {
        writer.println(configuration.getName() + " {");
        writer.indented(() -> writer.println(String.format("extendsFrom %s", String.join((CharSequence)", ", configuration.getExtendsFrom()))));
        writer.println("}");
    }

    @Override
    protected void writeDependency(IndentingWriter writer, Dependency dependency) {
        String quoteStyle = this.determineQuoteStyle(dependency.getVersion());
        String version = this.determineVersion(dependency.getVersion());
        String classifier = dependency.getClassifier();
        String type = dependency.getType();
        boolean hasExclusions = !dependency.getExclusions().isEmpty();
        writer.print(this.configurationForDependency(dependency));
        writer.print(hasExclusions ? "(" : " ");
        writer.print(quoteStyle + dependency.getGroupId() + ":" + dependency.getArtifactId() + (version != null ? ":" + version : "") + (classifier != null ? ":" + classifier : "") + (type != null ? "@" + type : "") + quoteStyle);
        if (hasExclusions) {
            writer.println(") {");
            writer.indented(() -> this.writeCollection(writer, dependency.getExclusions(), this::dependencyExclusionAsString));
            writer.println("}");
        } else {
            writer.println();
        }
    }

    private String dependencyExclusionAsString(Dependency.Exclusion exclusion) {
        return "exclude group: '" + exclusion.getGroupId() + "', module: '" + exclusion.getArtifactId() + "'";
    }

    private String determineQuoteStyle(VersionReference versionReference) {
        return versionReference != null && versionReference.isProperty() ? "\"" : "'";
    }

    @Override
    protected String bomAsString(BillOfMaterials bom) {
        String quoteStyle = this.determineQuoteStyle(bom.getVersion());
        return "mavenBom " + quoteStyle + bom.getGroupId() + ":" + bom.getArtifactId() + ":" + this.determineVersion(bom.getVersion()) + quoteStyle;
    }

    private String determineVersion(VersionReference versionReference) {
        if (versionReference != null) {
            if (versionReference.isProperty()) {
                VersionProperty property = versionReference.getProperty();
                return "${" + (property.isInternal() ? property.toCamelCaseFormat() : "property('" + property.toStandardFormat() + "')") + "}";
            }
            return versionReference.getValue();
        }
        return null;
    }

    @Override
    protected void writeTasks(IndentingWriter writer, GradleTaskContainer tasks) {
        tasks.values().filter(candidate -> candidate.getType() != null).forEach(task -> {
            writer.println();
            writer.println("tasks.withType(" + task.getName() + ") {");
            writer.indented(() -> this.writeTaskCustomization(writer, (GradleTask)task));
            writer.println("}");
        });
        tasks.values().filter(candidate -> candidate.getType() == null).forEach(task -> {
            writer.println();
            writer.println(task.getName() + " {");
            writer.indented(() -> this.writeTaskCustomization(writer, (GradleTask)task));
            writer.println("}");
        });
    }

    @Override
    protected String invocationAsString(GradleTask.Invocation invocation) {
        String arguments = invocation.getArguments().isEmpty() ? "()" : " " + String.join((CharSequence)", ", invocation.getArguments());
        return invocation.getTarget() + arguments;
    }

    @Override
    protected void writeProperty(IndentingWriter writer, String name, String value) {
        if (value != null) {
            writer.println(String.format("%s = '%s'", name, value));
        }
    }

    private <T, U> void writeNestedMap(IndentingWriter writer, String name, Map<T, U> map, BiFunction<T, U, String> converter) {
        if (!map.isEmpty()) {
            writer.println(name + " {");
            writer.indented(() -> this.writeMap(writer, map, converter));
            writer.println("}");
        }
    }
}

