/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem.maven;

import io.spring.initializr.generator.buildsystem.BuildSettings;
import io.spring.initializr.generator.buildsystem.maven.MavenDeveloper;
import io.spring.initializr.generator.buildsystem.maven.MavenLicense;
import io.spring.initializr.generator.buildsystem.maven.MavenParent;
import io.spring.initializr.generator.buildsystem.maven.MavenScm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class MavenBuildSettings
extends BuildSettings {
    private final MavenParent parent;
    private final String packaging;
    private final String name;
    private final String description;
    private final List<MavenLicense> licenses;
    private final List<MavenDeveloper> developers;
    private final MavenScm scm;
    private final String defaultGoal;
    private final String finalName;
    private final String sourceDirectory;
    private final String testSourceDirectory;

    protected MavenBuildSettings(Builder builder) {
        super(builder);
        this.parent = builder.parent;
        this.packaging = builder.packaging;
        this.name = builder.name;
        this.description = builder.description;
        this.licenses = Collections.unmodifiableList(new ArrayList(builder.licenses));
        this.developers = Collections.unmodifiableList(new ArrayList(builder.developers));
        this.scm = builder.scm.build();
        this.defaultGoal = builder.defaultGoal;
        this.finalName = builder.finalName;
        this.sourceDirectory = builder.sourceDirectory;
        this.testSourceDirectory = builder.testSourceDirectory;
    }

    public MavenParent getParent() {
        return this.parent;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<MavenLicense> getLicenses() {
        return this.licenses;
    }

    public List<MavenDeveloper> getDevelopers() {
        return this.developers;
    }

    public MavenScm getScm() {
        return this.scm;
    }

    public String getDefaultGoal() {
        return this.defaultGoal;
    }

    public String getFinalName() {
        return this.finalName;
    }

    public String getSourceDirectory() {
        return this.sourceDirectory;
    }

    public String getTestSourceDirectory() {
        return this.testSourceDirectory;
    }

    public static class Builder
    extends BuildSettings.Builder<Builder> {
        private MavenParent parent;
        private String packaging;
        private String name;
        private String description;
        private List<MavenLicense> licenses = new ArrayList<MavenLicense>();
        private List<MavenDeveloper> developers = new ArrayList<MavenDeveloper>();
        private final MavenScm.Builder scm = new MavenScm.Builder();
        private String defaultGoal;
        private String finalName;
        private String sourceDirectory;
        private String testSourceDirectory;

        public Builder coordinates(String groupId, String artifactId) {
            return (Builder)((Builder)this.group(groupId)).artifact(artifactId);
        }

        public Builder parent(String groupId, String artifactId, String version) {
            return this.parent(groupId, artifactId, version, "");
        }

        public Builder parent(String groupId, String artifactId, String version, String relativePath) {
            this.parent = new MavenParent(groupId, artifactId, version, relativePath);
            return (Builder)this.self();
        }

        public Builder packaging(String packaging) {
            this.packaging = packaging;
            return (Builder)this.self();
        }

        public Builder name(String name) {
            this.name = name;
            return (Builder)this.self();
        }

        public Builder description(String description) {
            this.description = description;
            return (Builder)this.self();
        }

        public Builder licenses(MavenLicense ... licenses) {
            this.licenses = licenses != null ? Arrays.asList(licenses) : new ArrayList<MavenLicense>();
            return (Builder)this.self();
        }

        public Builder developers(MavenDeveloper ... developers) {
            this.developers = developers != null ? Arrays.asList(developers) : new ArrayList<MavenDeveloper>();
            return (Builder)this.self();
        }

        public Builder scm(Consumer<MavenScm.Builder> scm) {
            scm.accept(this.scm);
            return (Builder)this.self();
        }

        public Builder finalName(String finalName) {
            this.finalName = finalName;
            return (Builder)this.self();
        }

        public Builder defaultGoal(String defaultGoal) {
            this.defaultGoal = defaultGoal;
            return (Builder)this.self();
        }

        public Builder sourceDirectory(String sourceDirectory) {
            this.sourceDirectory = sourceDirectory;
            return (Builder)this.self();
        }

        public Builder testSourceDirectory(String testSourceDirectory) {
            this.testSourceDirectory = testSourceDirectory;
            return (Builder)this.self();
        }

        @Override
        public MavenBuildSettings build() {
            return new MavenBuildSettings(this);
        }
    }
}

