/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem.maven;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MavenDeveloper {
    private final String id;
    private final String name;
    private final String email;
    private final String url;
    private final String organization;
    private final String organizationUrl;
    private final List<String> roles;
    private final String timezone;
    private final Map<String, String> properties;

    MavenDeveloper(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.email = builder.email;
        this.url = builder.url;
        this.organization = builder.organization;
        this.organizationUrl = builder.organizationUrl;
        this.roles = Collections.unmodifiableList(new ArrayList(builder.roles));
        this.timezone = builder.timezone;
        this.properties = Collections.unmodifiableMap(new LinkedHashMap(builder.properties));
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public String getUrl() {
        return this.url;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getOrganizationUrl() {
        return this.organizationUrl;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public static class Builder {
        private String id;
        private String name;
        private String email;
        private String url;
        private String organization;
        private String organizationUrl;
        private final List<String> roles = new ArrayList<String>();
        private String timezone;
        private final Map<String, String> properties = new LinkedHashMap<String, String>();

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder organization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder organizationUrl(String organizationUrl) {
            this.organizationUrl = organizationUrl;
            return this;
        }

        public Builder role(String role) {
            this.roles.add(role);
            return this;
        }

        public Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder property(String key, String value) {
            this.properties.put(key, value);
            return this;
        }

        public MavenDeveloper build() {
            return new MavenDeveloper(this);
        }
    }
}

