/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem;

import io.spring.initializr.generator.version.VersionProperty;
import java.util.AbstractMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Stream;

public class PropertyContainer {
    private final Map<String, String> properties = new TreeMap<String, String>();
    private final Map<VersionProperty, String> versions = new TreeMap<VersionProperty, String>();

    public boolean isEmpty() {
        return this.properties.isEmpty() && this.versions.isEmpty();
    }

    public boolean has(String name) {
        return this.properties.containsKey(name) || this.versions.keySet().stream().anyMatch(ref -> ref.toStandardFormat().equals(name));
    }

    public PropertyContainer property(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public PropertyContainer version(VersionProperty versionProperty, String version) {
        this.versions.put(versionProperty, version);
        return this;
    }

    public PropertyContainer version(String name, String version) {
        return this.version(VersionProperty.of(name, false), version);
    }

    public Stream<Map.Entry<String, String>> values() {
        return this.properties.entrySet().stream();
    }

    public Stream<Map.Entry<String, String>> versions(Function<VersionProperty, String> nameFactory) {
        return this.versions.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry(nameFactory.apply((VersionProperty)entry.getKey()), entry.getValue()));
    }
}

