/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem.maven;

import io.spring.initializr.generator.buildsystem.BomContainer;
import io.spring.initializr.generator.buildsystem.BuildItemResolver;
import io.spring.initializr.generator.buildsystem.DependencyContainer;
import io.spring.initializr.generator.buildsystem.MavenRepositoryContainer;
import io.spring.initializr.generator.buildsystem.PropertyContainer;
import io.spring.initializr.generator.buildsystem.maven.MavenDistributionManagement;
import io.spring.initializr.generator.buildsystem.maven.MavenPluginContainer;
import io.spring.initializr.generator.buildsystem.maven.MavenProfileActivation;
import io.spring.initializr.generator.buildsystem.maven.MavenResourceContainer;

public class MavenProfile {
    private final String id;
    private final MavenProfileActivation.Builder activation = new MavenProfileActivation.Builder();
    private final SettingsBuilder settings = new SettingsBuilder();
    private final PropertyContainer properties = new PropertyContainer();
    private final DependencyContainer dependencies;
    private final MavenResourceContainer resources = new MavenResourceContainer();
    private final MavenResourceContainer testResources = new MavenResourceContainer();
    private final MavenPluginContainer plugins = new MavenPluginContainer();
    private final BomContainer boms;
    private final MavenRepositoryContainer repositories;
    private final MavenRepositoryContainer pluginRepositories;
    private final MavenDistributionManagement.Builder distributionManagement = new MavenDistributionManagement.Builder();

    protected MavenProfile(String id, BuildItemResolver buildItemResolver) {
        this.id = id;
        this.dependencies = new DependencyContainer(buildItemResolver::resolveDependency);
        this.boms = new BomContainer(buildItemResolver::resolveBom);
        this.repositories = new MavenRepositoryContainer(buildItemResolver::resolveRepository);
        this.pluginRepositories = new MavenRepositoryContainer(buildItemResolver::resolveRepository);
    }

    public String getId() {
        return this.id;
    }

    public MavenProfileActivation.Builder activation() {
        return this.activation;
    }

    public MavenProfileActivation getActivation() {
        return this.activation.build();
    }

    public SettingsBuilder settings() {
        return this.settings;
    }

    public Settings getSettings() {
        return this.settings.build();
    }

    public PropertyContainer properties() {
        return this.properties;
    }

    public DependencyContainer dependencies() {
        return this.dependencies;
    }

    public BomContainer boms() {
        return this.boms;
    }

    public MavenRepositoryContainer repositories() {
        return this.repositories;
    }

    public MavenRepositoryContainer pluginRepositories() {
        return this.pluginRepositories;
    }

    public MavenDistributionManagement.Builder distributionManagement() {
        return this.distributionManagement;
    }

    public MavenDistributionManagement getDistributionManagement() {
        return this.distributionManagement.build();
    }

    public MavenResourceContainer resources() {
        return this.resources;
    }

    public MavenResourceContainer testResources() {
        return this.testResources;
    }

    public MavenPluginContainer plugins() {
        return this.plugins;
    }

    public static final class Settings {
        private final String defaultGoal;
        private final String finalName;

        protected Settings(SettingsBuilder builder) {
            this.defaultGoal = builder.defaultGoal;
            this.finalName = builder.finalName;
        }

        public String getDefaultGoal() {
            return this.defaultGoal;
        }

        public String getFinalName() {
            return this.finalName;
        }
    }

    public static class SettingsBuilder {
        private String defaultGoal;
        private String finalName;

        protected SettingsBuilder() {
        }

        public SettingsBuilder defaultGoal(String defaultGoal) {
            this.defaultGoal = defaultGoal;
            return this;
        }

        public SettingsBuilder finalName(String finalName) {
            this.finalName = finalName;
            return this;
        }

        public Settings build() {
            return new Settings(this);
        }
    }
}

