/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem.maven;

import io.spring.initializr.generator.buildsystem.BuildItemResolver;
import io.spring.initializr.generator.buildsystem.maven.MavenProfile;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;

public class MavenProfileContainer {
    private final Map<String, MavenProfile> profiles = new LinkedHashMap<String, MavenProfile>();
    private final BuildItemResolver buildItemResolver;

    public MavenProfileContainer(BuildItemResolver buildItemResolver) {
        this.buildItemResolver = buildItemResolver;
    }

    public boolean isEmpty() {
        return this.profiles.isEmpty();
    }

    public boolean has(String id) {
        return this.profiles.containsKey(id);
    }

    public Stream<String> ids() {
        return this.profiles.keySet().stream();
    }

    public Stream<MavenProfile> values() {
        return this.profiles.values().stream();
    }

    public MavenProfile id(String id) {
        return this.profiles.computeIfAbsent(id, key -> new MavenProfile(id, this.buildItemResolver));
    }

    public boolean remove(String id) {
        return this.profiles.remove(id) != null;
    }
}

