/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.language.groovy;

import io.spring.initializr.generator.language.Annotatable;
import io.spring.initializr.generator.language.Annotation;
import io.spring.initializr.generator.language.Parameter;
import io.spring.initializr.generator.language.groovy.GroovyStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class GroovyMethodDeclaration
implements Annotatable {
    private final List<Annotation> annotations = new ArrayList<Annotation>();
    private final String name;
    private final String returnType;
    private final int modifiers;
    private final List<Parameter> parameters;
    private final List<GroovyStatement> statements;

    private GroovyMethodDeclaration(String name, String returnType, int modifiers, List<Parameter> parameters, List<GroovyStatement> statements) {
        this.name = name;
        this.returnType = returnType;
        this.modifiers = modifiers;
        this.parameters = parameters;
        this.statements = statements;
    }

    public static Builder method(String name) {
        return new Builder(name);
    }

    String getName() {
        return this.name;
    }

    String getReturnType() {
        return this.returnType;
    }

    List<Parameter> getParameters() {
        return this.parameters;
    }

    int getModifiers() {
        return this.modifiers;
    }

    public List<GroovyStatement> getStatements() {
        return this.statements;
    }

    @Override
    public void annotate(Annotation annotation) {
        this.annotations.add(annotation);
    }

    @Override
    public List<Annotation> getAnnotations() {
        return Collections.unmodifiableList(this.annotations);
    }

    public static final class Builder {
        private final String name;
        private List<Parameter> parameters = new ArrayList<Parameter>();
        private String returnType = "void";
        private int modifiers = 1;

        private Builder(String name) {
            this.name = name;
        }

        public Builder modifiers(int modifiers) {
            this.modifiers = modifiers;
            return this;
        }

        public Builder returning(String returnType) {
            this.returnType = returnType;
            return this;
        }

        public Builder parameters(Parameter ... parameters) {
            this.parameters = Arrays.asList(parameters);
            return this;
        }

        public GroovyMethodDeclaration body(GroovyStatement ... statements) {
            return new GroovyMethodDeclaration(this.name, this.returnType, this.modifiers, this.parameters, Arrays.asList(statements));
        }
    }
}

