/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.language.groovy;

import io.spring.initializr.generator.io.IndentingWriter;
import io.spring.initializr.generator.io.IndentingWriterFactory;
import io.spring.initializr.generator.language.Annotatable;
import io.spring.initializr.generator.language.Annotation;
import io.spring.initializr.generator.language.Parameter;
import io.spring.initializr.generator.language.SourceCodeWriter;
import io.spring.initializr.generator.language.SourceStructure;
import io.spring.initializr.generator.language.groovy.GroovyCompilationUnit;
import io.spring.initializr.generator.language.groovy.GroovyExpression;
import io.spring.initializr.generator.language.groovy.GroovyExpressionStatement;
import io.spring.initializr.generator.language.groovy.GroovyFieldDeclaration;
import io.spring.initializr.generator.language.groovy.GroovyMethodDeclaration;
import io.spring.initializr.generator.language.groovy.GroovyMethodInvocation;
import io.spring.initializr.generator.language.groovy.GroovyReturnStatement;
import io.spring.initializr.generator.language.groovy.GroovySourceCode;
import io.spring.initializr.generator.language.groovy.GroovyStatement;
import io.spring.initializr.generator.language.groovy.GroovyTypeDeclaration;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GroovySourceCodeWriter
implements SourceCodeWriter<GroovySourceCode> {
    private static final Map<Predicate<Integer>, String> TYPE_MODIFIERS;
    private static final Map<Predicate<Integer>, String> FIELD_MODIFIERS;
    private static final Map<Predicate<Integer>, String> METHOD_MODIFIERS;
    private final IndentingWriterFactory indentingWriterFactory;

    public GroovySourceCodeWriter(IndentingWriterFactory indentingWriterFactory) {
        this.indentingWriterFactory = indentingWriterFactory;
    }

    @Override
    public void writeTo(SourceStructure structure, GroovySourceCode sourceCode) throws IOException {
        for (GroovyCompilationUnit compilationUnit : sourceCode.getCompilationUnits()) {
            this.writeTo(structure, compilationUnit);
        }
    }

    @Override
    private void writeTo(SourceStructure structure, GroovyCompilationUnit compilationUnit) throws IOException {
        Path output = structure.createSourceFile(compilationUnit.getPackageName(), compilationUnit.getName());
        try (IndentingWriter writer = this.indentingWriterFactory.createIndentingWriter("groovy", Files.newBufferedWriter(output, new OpenOption[0]));){
            writer.println("package " + compilationUnit.getPackageName());
            writer.println();
            Set<String> imports = this.determineImports(compilationUnit);
            if (!imports.isEmpty()) {
                for (String importedType : imports) {
                    writer.println("import " + importedType);
                }
                writer.println();
            }
            for (GroovyTypeDeclaration type : compilationUnit.getTypeDeclarations()) {
                List<GroovyMethodDeclaration> methodDeclarations;
                this.writeAnnotations(writer, type);
                this.writeModifiers(writer, TYPE_MODIFIERS, type.getModifiers());
                writer.print("class " + type.getName());
                if (type.getExtends() != null) {
                    writer.print(" extends " + this.getUnqualifiedName(type.getExtends()));
                }
                writer.println(" {");
                writer.println();
                List<GroovyFieldDeclaration> fieldDeclarations = type.getFieldDeclarations();
                if (!fieldDeclarations.isEmpty()) {
                    writer.indented(() -> {
                        for (GroovyFieldDeclaration fieldDeclaration : fieldDeclarations) {
                            this.writeFieldDeclaration(writer, fieldDeclaration);
                        }
                    });
                }
                if (!(methodDeclarations = type.getMethodDeclarations()).isEmpty()) {
                    writer.indented(() -> {
                        for (GroovyMethodDeclaration methodDeclaration : methodDeclarations) {
                            this.writeMethodDeclaration(writer, methodDeclaration);
                        }
                    });
                }
                writer.println("}");
            }
        }
    }

    private void writeAnnotations(IndentingWriter writer, Annotatable annotatable) {
        annotatable.getAnnotations().forEach(annotation -> this.writeAnnotation(writer, (Annotation)annotation));
    }

    private void writeAnnotation(IndentingWriter writer, Annotation annotation) {
        writer.print("@" + this.getUnqualifiedName(annotation.getName()));
        List<Annotation.Attribute> attributes = annotation.getAttributes();
        if (!attributes.isEmpty()) {
            writer.print("(");
            if (attributes.size() == 1 && attributes.get(0).getName().equals("value")) {
                writer.print(this.formatAnnotationAttribute(attributes.get(0)));
            } else {
                writer.print(attributes.stream().map(attribute -> attribute.getName() + " = " + this.formatAnnotationAttribute((Annotation.Attribute)attribute)).collect(Collectors.joining(", ")));
            }
            writer.print(")");
        }
        writer.println();
    }

    private String formatAnnotationAttribute(Annotation.Attribute attribute) {
        List<String> values = attribute.getValues();
        if (attribute.getType().equals(Class.class)) {
            return this.formatValues(values, this::getUnqualifiedName);
        }
        if (Enum.class.isAssignableFrom(attribute.getType())) {
            return this.formatValues(values, value -> {
                String enumValue = value.substring(value.lastIndexOf(".") + 1);
                String enumClass = value.substring(0, value.lastIndexOf("."));
                return String.format("%s.%s", this.getUnqualifiedName(enumClass), enumValue);
            });
        }
        if (attribute.getType().equals(String.class)) {
            return this.formatValues(values, value -> String.format("\"%s\"", value));
        }
        return this.formatValues(values, value -> String.format("%s", value));
    }

    private String formatValues(List<String> values, Function<String, String> formatter) {
        String result = values.stream().map(formatter).collect(Collectors.joining(", "));
        return values.size() > 1 ? "[ " + result + " ]" : result;
    }

    private void writeFieldDeclaration(IndentingWriter writer, GroovyFieldDeclaration fieldDeclaration) {
        this.writeAnnotations(writer, fieldDeclaration);
        this.writeModifiers(writer, FIELD_MODIFIERS, fieldDeclaration.getModifiers());
        writer.print(this.getUnqualifiedName(fieldDeclaration.getReturnType()));
        writer.print(" ");
        writer.print(fieldDeclaration.getName());
        if (fieldDeclaration.isInitialized()) {
            writer.print(" = ");
            writer.print(String.valueOf(fieldDeclaration.getValue()));
        }
        writer.println();
        writer.println();
    }

    private void writeMethodDeclaration(IndentingWriter writer, GroovyMethodDeclaration methodDeclaration) {
        this.writeAnnotations(writer, methodDeclaration);
        this.writeModifiers(writer, METHOD_MODIFIERS, methodDeclaration.getModifiers());
        writer.print(this.getUnqualifiedName(methodDeclaration.getReturnType()) + " " + methodDeclaration.getName() + "(");
        List<Parameter> parameters = methodDeclaration.getParameters();
        if (!parameters.isEmpty()) {
            writer.print(parameters.stream().map(parameter -> this.getUnqualifiedName(parameter.getType()) + " " + parameter.getName()).collect(Collectors.joining(", ")));
        }
        writer.println(") {");
        writer.indented(() -> {
            List<GroovyStatement> statements = methodDeclaration.getStatements();
            for (GroovyStatement statement : statements) {
                if (statement instanceof GroovyExpressionStatement) {
                    this.writeExpression(writer, ((GroovyExpressionStatement)statement).getExpression());
                } else if (statement instanceof GroovyReturnStatement) {
                    this.writeExpression(writer, ((GroovyReturnStatement)statement).getExpression());
                }
                writer.println();
            }
        });
        writer.println("}");
        writer.println();
    }

    private void writeModifiers(IndentingWriter writer, Map<Predicate<Integer>, String> availableModifiers, int declaredModifiers) {
        String modifiers = availableModifiers.entrySet().stream().filter(entry -> ((Predicate)entry.getKey()).test(declaredModifiers)).map(Map.Entry::getValue).collect(Collectors.joining(" "));
        if (!modifiers.isEmpty()) {
            writer.print(modifiers);
            writer.print(" ");
        }
    }

    private void writeExpression(IndentingWriter writer, GroovyExpression expression) {
        if (expression instanceof GroovyMethodInvocation) {
            this.writeMethodInvocation(writer, (GroovyMethodInvocation)expression);
        }
    }

    private void writeMethodInvocation(IndentingWriter writer, GroovyMethodInvocation methodInvocation) {
        writer.print(this.getUnqualifiedName(methodInvocation.getTarget()) + "." + methodInvocation.getName() + "(" + String.join((CharSequence)", ", methodInvocation.getArguments()) + ")");
    }

    private Set<String> determineImports(GroovyCompilationUnit compilationUnit) {
        ArrayList<String> imports = new ArrayList<String>();
        for (GroovyTypeDeclaration typeDeclaration : compilationUnit.getTypeDeclarations()) {
            if (this.requiresImport(typeDeclaration.getExtends())) {
                imports.add(typeDeclaration.getExtends());
            }
            imports.addAll(this.getRequiredImports(typeDeclaration.getAnnotations(), this::determineImports));
            for (GroovyFieldDeclaration fieldDeclaration : typeDeclaration.getFieldDeclarations()) {
                if (this.requiresImport(fieldDeclaration.getReturnType())) {
                    imports.add(fieldDeclaration.getReturnType());
                }
                imports.addAll(this.getRequiredImports(fieldDeclaration.getAnnotations(), this::determineImports));
            }
            for (GroovyMethodDeclaration methodDeclaration : typeDeclaration.getMethodDeclarations()) {
                if (this.requiresImport(methodDeclaration.getReturnType())) {
                    imports.add(methodDeclaration.getReturnType());
                }
                imports.addAll(this.getRequiredImports(methodDeclaration.getAnnotations(), this::determineImports));
                imports.addAll(this.getRequiredImports(methodDeclaration.getParameters(), (T parameter) -> Collections.singletonList(parameter.getType())));
                imports.addAll(this.getRequiredImports(methodDeclaration.getStatements().stream().filter(GroovyExpressionStatement.class::isInstance).map(GroovyExpressionStatement.class::cast).map(GroovyExpressionStatement::getExpression).filter(GroovyMethodInvocation.class::isInstance).map(GroovyMethodInvocation.class::cast), (T methodInvocation) -> Collections.singleton(methodInvocation.getTarget())));
            }
        }
        Collections.sort(imports);
        return new LinkedHashSet<String>(imports);
    }

    private Collection<String> determineImports(Annotation annotation) {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add(annotation.getName());
        annotation.getAttributes().forEach(attribute -> {
            if (attribute.getType() == Class.class) {
                imports.addAll(attribute.getValues());
            }
            if (Enum.class.isAssignableFrom(attribute.getType())) {
                imports.addAll(attribute.getValues().stream().map(value -> value.substring(0, value.lastIndexOf("."))).collect(Collectors.toList()));
            }
        });
        return imports;
    }

    private <T> List<String> getRequiredImports(List<T> candidates, Function<T, Collection<String>> mapping) {
        return this.getRequiredImports(candidates.stream(), mapping);
    }

    private <T> List<String> getRequiredImports(Stream<T> candidates, Function<T, Collection<String>> mapping) {
        return candidates.map(mapping).flatMap(Collection::stream).filter(this::requiresImport).collect(Collectors.toList());
    }

    private String getUnqualifiedName(String name) {
        if (!name.contains(".")) {
            return name;
        }
        return name.substring(name.lastIndexOf(".") + 1);
    }

    private boolean requiresImport(String name) {
        if (name == null || !name.contains(".")) {
            return false;
        }
        String packageName = name.substring(0, name.lastIndexOf(46));
        return !"java.lang".equals(packageName);
    }

    static {
        LinkedHashMap<Predicate<Integer>, String> typeModifiers = new LinkedHashMap<Predicate<Integer>, String>();
        typeModifiers.put(Modifier::isProtected, "protected");
        typeModifiers.put(Modifier::isPrivate, "private");
        typeModifiers.put(Modifier::isAbstract, "abstract");
        typeModifiers.put(Modifier::isStatic, "static");
        typeModifiers.put(Modifier::isFinal, "final");
        typeModifiers.put(Modifier::isStrict, "strictfp");
        TYPE_MODIFIERS = typeModifiers;
        LinkedHashMap<Predicate<Integer>, String> fieldModifiers = new LinkedHashMap<Predicate<Integer>, String>();
        fieldModifiers.put(Modifier::isPublic, "public");
        fieldModifiers.put(Modifier::isProtected, "protected");
        fieldModifiers.put(Modifier::isPrivate, "private");
        fieldModifiers.put(Modifier::isStatic, "static");
        fieldModifiers.put(Modifier::isFinal, "final");
        fieldModifiers.put(Modifier::isTransient, "transient");
        fieldModifiers.put(Modifier::isVolatile, "volatile");
        FIELD_MODIFIERS = fieldModifiers;
        LinkedHashMap<Predicate<Integer>, String> methodModifiers = new LinkedHashMap<Predicate<Integer>, String>(typeModifiers);
        methodModifiers.put(Modifier::isSynchronized, "synchronized");
        methodModifiers.put(Modifier::isNative, "native");
        METHOD_MODIFIERS = methodModifiers;
    }
}

