/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.project;

import io.spring.initializr.generator.project.DefaultProjectDescriptionDiffFactory;
import io.spring.initializr.generator.project.MutableProjectDescription;
import io.spring.initializr.generator.project.ProjectAssetGenerator;
import io.spring.initializr.generator.project.ProjectDescription;
import io.spring.initializr.generator.project.ProjectDescriptionCustomizer;
import io.spring.initializr.generator.project.ProjectDescriptionDiff;
import io.spring.initializr.generator.project.ProjectDescriptionDiffFactory;
import io.spring.initializr.generator.project.ProjectGenerationConfiguration;
import io.spring.initializr.generator.project.ProjectGenerationContext;
import io.spring.initializr.generator.project.ProjectGenerationException;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.core.io.support.SpringFactoriesLoader;

public class ProjectGenerator {
    private final Consumer<ProjectGenerationContext> contextConsumer;
    private final Supplier<? extends ProjectGenerationContext> contextFactory;

    public ProjectGenerator(Consumer<ProjectGenerationContext> contextConsumer, Supplier<? extends ProjectGenerationContext> contextFactory) {
        this.contextConsumer = contextConsumer;
        this.contextFactory = contextFactory;
    }

    public ProjectGenerator(Consumer<ProjectGenerationContext> contextConsumer) {
        this(contextConsumer, ProjectGenerator.defaultContextFactory());
    }

    private static Supplier<ProjectGenerationContext> defaultContextFactory() {
        return () -> {
            ProjectGenerationContext context = new ProjectGenerationContext();
            context.setAllowBeanDefinitionOverriding(false);
            return context;
        };
    }

    public <T> T generate(ProjectDescription description, ProjectAssetGenerator<T> projectAssetGenerator) throws ProjectGenerationException {
        Throwable throwable = null;
        try (ProjectGenerationContext context = this.contextFactory.get();){
            T t;
            this.registerProjectDescription(context, description);
            this.registerProjectContributors(context, description);
            this.contextConsumer.accept(context);
            context.refresh();
            try {
                t = projectAssetGenerator.generate(context);
            }
            catch (IOException ex) {
                try {
                    throw new ProjectGenerationException("Failed to generate project", ex);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            return t;
        }
    }

    protected List<String> getCandidateProjectGenerationConfigurations(ProjectDescription description) {
        return SpringFactoriesLoader.loadFactoryNames(ProjectGenerationConfiguration.class, (ClassLoader)this.getClass().getClassLoader());
    }

    private void registerProjectDescription(ProjectGenerationContext context, ProjectDescription description) {
        context.registerBean(ProjectDescription.class, this.resolve(description, context), new BeanDefinitionCustomizer[0]);
    }

    private void registerProjectContributors(ProjectGenerationContext context, ProjectDescription description) {
        this.getCandidateProjectGenerationConfigurations(description).forEach(configurationClassName -> {
            GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
            beanDefinition.setBeanClassName(configurationClassName);
            context.registerBeanDefinition((String)configurationClassName, (BeanDefinition)beanDefinition);
        });
    }

    private Supplier<ProjectDescription> resolve(ProjectDescription description, ProjectGenerationContext context) {
        return () -> {
            if (description instanceof MutableProjectDescription) {
                MutableProjectDescription mutableDescription = (MutableProjectDescription)description;
                ProjectDescriptionDiffFactory diffFactory = (ProjectDescriptionDiffFactory)context.getBeanProvider(ProjectDescriptionDiffFactory.class).getIfAvailable(DefaultProjectDescriptionDiffFactory::new);
                ProjectDescriptionDiff diff = diffFactory.create(mutableDescription);
                context.registerBean(ProjectDescriptionDiff.class, () -> diff, new BeanDefinitionCustomizer[0]);
                context.getBeanProvider(ProjectDescriptionCustomizer.class).orderedStream().forEach(customizer -> customizer.customize(mutableDescription));
            }
            return description;
        };
    }
}

