/*
 * Copyright 2012-2023 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.spring.initializr.generator.language.kotlin;

import java.util.Arrays;
import java.util.List;

import io.spring.initializr.generator.language.CodeBlock;

/**
 * An invocation of a function.
 *
 * @author Stephane Nicoll
 * @deprecated since 0.20.0 in favor of {@link CodeBlock}
 */
@Deprecated(since = "0.20.0", forRemoval = true)
public class KotlinFunctionInvocation extends KotlinExpression {

	private final String target;

	private final String name;

	private final List<String> arguments;

	public KotlinFunctionInvocation(String target, String name, String... arguments) {
		this.target = target;
		this.name = name;
		this.arguments = Arrays.asList(arguments);
	}

	public String getTarget() {
		return this.target;
	}

	public String getName() {
		return this.name;
	}

	public List<String> getArguments() {
		return this.arguments;
	}

}
