/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem;

import io.spring.initializr.generator.buildsystem.BuildSystemFactory;
import io.spring.initializr.generator.language.Language;
import io.spring.initializr.generator.language.SourceStructure;
import java.nio.file.Path;
import java.util.Objects;
import org.springframework.core.io.support.SpringFactoriesLoader;

public interface BuildSystem {
    public String id();

    default public String dialect() {
        return null;
    }

    default public SourceStructure getMainSource(Path projectRoot, Language language) {
        return new SourceStructure(projectRoot.resolve("src/main/"), language);
    }

    default public SourceStructure getTestSource(Path projectRoot, Language language) {
        return new SourceStructure(projectRoot.resolve("src/test/"), language);
    }

    public static BuildSystem forId(String id) {
        return BuildSystem.forIdAndDialect(id, null);
    }

    public static BuildSystem forIdAndDialect(String id, String dialect) {
        return SpringFactoriesLoader.loadFactories(BuildSystemFactory.class, (ClassLoader)BuildSystem.class.getClassLoader()).stream().map(factory -> factory.createBuildSystem(id, dialect)).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalStateException("Unrecognized build system id '" + id + "' and dialect '" + dialect + "'"));
    }
}

