/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem.gradle;

import io.spring.initializr.generator.buildsystem.Dependency;

public class GradleDependency
extends Dependency {
    private final String configuration;

    protected GradleDependency(Builder builder) {
        super(builder);
        this.configuration = builder.configuration;
    }

    public static Builder withCoordinates(String groupId, String artifactId) {
        return new Builder(groupId, artifactId);
    }

    public static Builder from(Dependency dependency) {
        return new Builder(dependency.getGroupId(), dependency.getArtifactId()).initialize(dependency);
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public static class Builder
    extends Dependency.Builder<Builder> {
        private String configuration;

        protected Builder(String groupId, String artifactId) {
            super(groupId, artifactId);
        }

        public Builder configuration(String configuration) {
            this.configuration = configuration;
            return (Builder)this.self();
        }

        @Override
        protected Builder initialize(Dependency dependency) {
            super.initialize(dependency);
            if (dependency instanceof GradleDependency) {
                this.configuration(((GradleDependency)dependency).getConfiguration());
            }
            return (Builder)this.self();
        }

        @Override
        public GradleDependency build() {
            return new GradleDependency(this);
        }
    }
}

