/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem.maven;

import io.spring.initializr.generator.buildsystem.Dependency;

public class MavenDependency
extends Dependency {
    protected final boolean optional;

    protected MavenDependency(Builder builder) {
        super(builder);
        this.optional = builder.optional;
    }

    public static Builder withCoordinates(String groupId, String artifactId) {
        return new Builder(groupId, artifactId);
    }

    public static Builder from(Dependency dependency) {
        return new Builder(dependency.getGroupId(), dependency.getArtifactId()).initialize(dependency);
    }

    public boolean isOptional() {
        return this.optional;
    }

    public static class Builder
    extends Dependency.Builder<Builder> {
        private boolean optional;

        protected Builder(String groupId, String artifactId) {
            super(groupId, artifactId);
        }

        public Builder optional(boolean optional) {
            this.optional = optional;
            return (Builder)this.self();
        }

        @Override
        protected Builder initialize(Dependency dependency) {
            super.initialize(dependency);
            if (dependency instanceof MavenDependency) {
                this.optional(((MavenDependency)dependency).isOptional());
            }
            return (Builder)this.self();
        }

        @Override
        public MavenDependency build() {
            return new MavenDependency(this);
        }
    }
}

