/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem.maven;

import io.spring.initializr.generator.buildsystem.maven.MavenExtension;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class MavenExtensionContainer {
    private final Map<String, MavenExtension.Builder> extensions = new LinkedHashMap<String, MavenExtension.Builder>();

    public boolean isEmpty() {
        return this.extensions.isEmpty();
    }

    public boolean has(String groupId, String artifactId) {
        return this.extensions.containsKey(this.extensionKey(groupId, artifactId));
    }

    public Stream<MavenExtension> values() {
        return this.extensions.values().stream().map(MavenExtension.Builder::build);
    }

    public void add(String groupId, String artifactId, String version) {
        this.add(groupId, artifactId, (MavenExtension.Builder extension) -> extension.version(version));
    }

    public void add(String groupId, String artifactId, Consumer<MavenExtension.Builder> extension) {
        extension.accept(this.addExtension(groupId, artifactId));
    }

    private MavenExtension.Builder addExtension(String groupId, String artifactId) {
        return this.extensions.computeIfAbsent(this.extensionKey(groupId, artifactId), extensionId -> new MavenExtension.Builder(groupId, artifactId));
    }

    public boolean remove(String groupId, String artifactId) {
        return this.extensions.remove(this.extensionKey(groupId, artifactId)) != null;
    }

    private String extensionKey(String groupId, String artifactId) {
        return String.format("%s:%s", groupId, artifactId);
    }
}

