/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem.maven;

public class MavenProfileActivation {
    private final Boolean activeByDefault;
    private final String jdk;
    private final Os os;
    private final Property property;
    private final File file;

    protected MavenProfileActivation(Builder builder) {
        this.activeByDefault = builder.activeByDefault;
        this.jdk = builder.jdk;
        this.os = builder.os;
        this.property = builder.property;
        this.file = builder.fileExists != null || builder.fileMissing != null ? new File(builder.fileExists, builder.fileMissing) : null;
    }

    public boolean isEmpty() {
        return this.activeByDefault == null && this.jdk == null && this.os == null && this.property == null && this.file == null;
    }

    public Boolean getActiveByDefault() {
        return this.activeByDefault;
    }

    public String getJdk() {
        return this.jdk;
    }

    public Os getOs() {
        return this.os;
    }

    public Property getProperty() {
        return this.property;
    }

    public File getFile() {
        return this.file;
    }

    public static class Builder {
        private Boolean activeByDefault;
        private String jdk;
        private Os os;
        private Property property;
        private String fileExists;
        private String fileMissing;

        protected Builder() {
        }

        public Builder activeByDefault(Boolean activeByDefault) {
            this.activeByDefault = activeByDefault;
            return this;
        }

        public Builder jdk(String jdk) {
            this.jdk = jdk;
            return this;
        }

        public Builder os(String name, String family, String arch, String version) {
            this.os = name == null && family == null && arch == null && version == null ? null : new Os(name, family, arch, version);
            return this;
        }

        public Builder property(String name, String value) {
            this.property = name == null ? null : new Property(name, value);
            return this;
        }

        public Builder fileExists(String existingFile) {
            this.fileExists = existingFile;
            return this;
        }

        public Builder fileMissing(String missingFile) {
            this.fileMissing = missingFile;
            return this;
        }

        public MavenProfileActivation build() {
            return new MavenProfileActivation(this);
        }
    }

    public static final class Os {
        private final String name;
        private final String family;
        private final String arch;
        private final String version;

        Os(String name, String family, String arch, String version) {
            this.name = name;
            this.family = family;
            this.arch = arch;
            this.version = version;
        }

        public String getName() {
            return this.name;
        }

        public String getFamily() {
            return this.family;
        }

        public String getArch() {
            return this.arch;
        }

        public String getVersion() {
            return this.version;
        }
    }

    public static final class Property {
        private final String name;
        private final String value;

        Property(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static final class File {
        private final String exists;
        private final String missing;

        File(String exists, String missing) {
            this.missing = missing;
            this.exists = exists;
        }

        public String getExists() {
            return this.exists;
        }

        public String getMissing() {
            return this.missing;
        }
    }
}

