/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.language;

import java.util.List;
import java.util.Objects;
import javax.lang.model.SourceVersion;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class ClassName {
    private static final List<String> PRIMITIVE_NAMES = List.of("boolean", "byte", "short", "int", "long", "char", "float", "double", "void");
    private final String packageName;
    private final String simpleName;
    private final ClassName enclosingType;
    private String canonicalName;

    private ClassName(String packageName, String simpleName, ClassName enclosingType) {
        this.packageName = packageName;
        this.simpleName = simpleName;
        this.enclosingType = enclosingType;
    }

    public static ClassName of(String fqName) {
        Assert.notNull((Object)fqName, (String)"'className' must not be null");
        if (!ClassName.isValidClassName(fqName)) {
            throw new IllegalStateException("Invalid class name '" + fqName + "'");
        }
        if (!fqName.contains("$")) {
            return ClassName.createClassName(fqName);
        }
        String[] elements = fqName.split("(?<!\\$)\\$(?!\\$)");
        ClassName className = ClassName.createClassName(elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            className = new ClassName(className.getPackageName(), elements[i], className);
        }
        return className;
    }

    public static ClassName of(Class<?> type) {
        return ClassName.of(type.getName());
    }

    public String getName() {
        ClassName enclosingType = this.getEnclosingType();
        String simpleName = this.getSimpleName();
        return enclosingType != null ? enclosingType.getName() + "$" + simpleName : this.addPackageIfNecessary(simpleName);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public ClassName getEnclosingType() {
        return this.enclosingType;
    }

    public String getCanonicalName() {
        if (this.canonicalName == null) {
            StringBuilder names = new StringBuilder();
            ClassName.buildName(this, names);
            this.canonicalName = this.addPackageIfNecessary(names.toString());
        }
        return this.canonicalName;
    }

    private boolean isPrimitive() {
        return ClassName.isPrimitive(this.getSimpleName());
    }

    private static boolean isPrimitive(String name) {
        return PRIMITIVE_NAMES.stream().anyMatch(name::startsWith);
    }

    private String addPackageIfNecessary(String part) {
        if (this.packageName.isEmpty() || this.packageName.equals("java.lang") && this.isPrimitive()) {
            return part;
        }
        return this.packageName + "." + part;
    }

    private static boolean isValidClassName(String className) {
        for (String s : className.split("\\.", -1)) {
            String candidate = s.replace("[", "").replace("]", "");
            if (SourceVersion.isIdentifier(candidate)) continue;
            return false;
        }
        return true;
    }

    private static ClassName createClassName(String className) {
        int i = className.lastIndexOf(46);
        if (i != -1) {
            return new ClassName(className.substring(0, i), className.substring(i + 1), null);
        }
        String packageName = ClassName.isPrimitive(className) ? "java.lang" : "";
        return new ClassName(packageName, className, null);
    }

    private static void buildName(ClassName className, StringBuilder sb) {
        if (className == null) {
            return;
        }
        Object typeName = className.getEnclosingType() != null ? "." + className.getSimpleName() : className.getSimpleName();
        sb.insert(0, (String)typeName);
        ClassName.buildName(className.getEnclosingType(), sb);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ClassName)) {
            return false;
        }
        ClassName className = (ClassName)other;
        return this.getCanonicalName().equals(className.getCanonicalName());
    }

    public int hashCode() {
        return Objects.hash(this.getCanonicalName());
    }

    public String toString() {
        return this.getCanonicalName();
    }
}

