/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.language;

import io.spring.initializr.generator.io.IndentingWriter;
import io.spring.initializr.generator.language.ClassName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collector;
import java.util.stream.StreamSupport;
import org.springframework.util.ClassUtils;

public final class CodeBlock {
    public static final FormattingOptions JAVA_FORMATTING_OPTIONS = new JavaFormattingOptions();
    private final List<String> parts;
    private final List<Object> args;
    private final List<String> imports;

    private CodeBlock(Builder builder) {
        this.parts = List.copyOf(builder.parts);
        this.args = List.copyOf(builder.args);
        this.imports = List.copyOf(builder.imports);
    }

    public List<String> getImports() {
        return this.imports;
    }

    public void write(IndentingWriter writer, FormattingOptions options) {
        int argIndex = 0;
        Iterator<String> iterator = this.parts.iterator();
        while (iterator.hasNext()) {
            String part;
            switch (part = iterator.next()) {
                case "$L": {
                    Object value = this.args.get(argIndex++);
                    if (value instanceof CodeBlock) {
                        CodeBlock code = (CodeBlock)value;
                        code.write(writer, options);
                        break;
                    }
                    writer.print(String.valueOf(value));
                    break;
                }
                case "$S": {
                    Object value = (String)this.args.get(argIndex++);
                    String valueToEmit = value != null ? CodeBlock.quote((String)value) : "null";
                    writer.print(valueToEmit);
                    break;
                }
                case "$T": {
                    String className = (String)this.args.get(argIndex++);
                    writer.print(className);
                    break;
                }
                case "$]": {
                    writer.println(options.statementSeparator());
                    break;
                }
                case "$$": {
                    writer.print("$");
                    break;
                }
                default: {
                    writer.print(part);
                }
            }
        }
    }

    private static String quote(String value) {
        StringBuilder result = new StringBuilder(value.length() + 2);
        result.append('\"');
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\'') {
                result.append("'");
                continue;
            }
            if (c == '\"') {
                result.append("\\\"");
                continue;
            }
            result.append(c);
        }
        result.append('\"');
        return result.toString();
    }

    public static CodeBlock of(String format, Object ... args) {
        return new Builder().add(format, args).build();
    }

    public static CodeBlock ofStatement(String format, Object ... args) {
        return new Builder().addStatement(format, args).build();
    }

    public static CodeBlock join(Iterable<CodeBlock> codeBlocks, String separator) {
        return StreamSupport.stream(codeBlocks.spliterator(), false).collect(CodeBlock.joining(separator));
    }

    public static Collector<CodeBlock, ?, CodeBlock> joining(String separator) {
        return Collector.of(() -> new CodeBlockJoiner(separator, CodeBlock.builder()), CodeBlockJoiner::add, CodeBlockJoiner::merge, CodeBlockJoiner::join, new Collector.Characteristics[0]);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final List<String> parts = new ArrayList<String>();
        private final List<Object> args = new ArrayList<Object>();
        private final List<String> imports = new ArrayList<String>();

        private Builder() {
        }

        public Builder add(CodeBlock codeBlock) {
            this.parts.addAll(codeBlock.parts);
            this.args.addAll(codeBlock.args);
            this.imports.addAll(codeBlock.imports);
            return this;
        }

        public Builder add(String format, Object ... args) {
            int relativeParameterCount = 0;
            int p = 0;
            while (p < format.length()) {
                char placeHolderType;
                if (format.charAt(p) != '$') {
                    int nextP = format.indexOf(36, p + 1);
                    nextP = nextP != -1 ? nextP : format.length();
                    this.parts.add(format.substring(p, nextP));
                    p = nextP;
                    continue;
                }
                if (++p >= format.length()) {
                    throw new IllegalArgumentException("Should not end with '$': '%s'".formatted(format));
                }
                if (!this.isNoArgPlaceholder(placeHolderType = format.charAt(p++))) {
                    int index;
                    if ((index = relativeParameterCount++) >= args.length) {
                        throw new IllegalArgumentException("Argument mismatch for '%s', expected at least %s %s, got %s".formatted(format, relativeParameterCount, relativeParameterCount > 1 ? "arguments" : "argument", args.length));
                    }
                    this.addArgument(format, placeHolderType, args[index]);
                }
                this.parts.add("$" + placeHolderType);
            }
            if (relativeParameterCount != args.length) {
                throw new IllegalArgumentException("Argument mismatch for '%s', expected %s %s, got %s".formatted(format, relativeParameterCount, relativeParameterCount > 1 ? "arguments" : "argument", args.length));
            }
            return this;
        }

        private boolean isNoArgPlaceholder(char c) {
            return c == '$' || c == ']';
        }

        private void addArgument(String format, char c, Object arg) {
            switch (c) {
                case 'L': {
                    this.args.add(this.arg(arg));
                    break;
                }
                case 'S': {
                    this.args.add(this.argToString(arg));
                    break;
                }
                case 'T': {
                    this.args.add(this.argToType(arg));
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unsupported placeholder '$%s' for '%s'", Character.valueOf(c), format));
                }
            }
        }

        private Object arg(Object arg) {
            if (arg instanceof CodeBlock) {
                CodeBlock code = (CodeBlock)arg;
                this.imports.addAll(code.getImports());
            }
            return arg;
        }

        private String argToString(Object arg) {
            return arg != null ? String.valueOf(arg) : null;
        }

        private String argToType(Object arg) {
            if (arg instanceof Class) {
                Class type = (Class)arg;
                this.imports.add(type.getName());
                return type.getSimpleName();
            }
            if (arg instanceof ClassName) {
                ClassName className = (ClassName)arg;
                this.imports.add(className.getName());
                return className.getSimpleName();
            }
            if (arg instanceof String) {
                String fqName = (String)arg;
                this.imports.add(fqName);
                return ClassUtils.getShortName((String)fqName);
            }
            throw new IllegalArgumentException("Failed to extract type from '%s'".formatted(arg));
        }

        public Builder addStatement(CodeBlock codeBlock) {
            this.add(codeBlock);
            this.parts.add("$]");
            return this;
        }

        public Builder addStatement(String format, Object ... args) {
            this.add(format, args);
            this.parts.add("$]");
            return this;
        }

        public CodeBlock build() {
            return new CodeBlock(this);
        }
    }

    public static interface FormattingOptions {
        public String statementSeparator();

        public CodeBlock arrayOf(CodeBlock ... var1);

        public CodeBlock classReference(ClassName var1);
    }

    private static final class CodeBlockJoiner {
        private final String delimiter;
        private final Builder builder;
        private boolean first = true;

        CodeBlockJoiner(String delimiter, Builder builder) {
            this.delimiter = delimiter;
            this.builder = builder;
        }

        CodeBlockJoiner add(CodeBlock codeBlock) {
            if (!this.first) {
                this.builder.add(this.delimiter, new Object[0]);
            }
            this.first = false;
            this.builder.add(codeBlock);
            return this;
        }

        CodeBlockJoiner merge(CodeBlockJoiner other) {
            CodeBlock otherBlock = other.builder.build();
            if (!otherBlock.parts.isEmpty()) {
                this.add(otherBlock);
            }
            return this;
        }

        CodeBlock join() {
            return this.builder.build();
        }
    }

    private static class JavaFormattingOptions
    implements FormattingOptions {
        private JavaFormattingOptions() {
        }

        @Override
        public String statementSeparator() {
            return ";";
        }

        @Override
        public CodeBlock arrayOf(CodeBlock ... values) {
            return CodeBlock.of("{ $L }", CodeBlock.join(Arrays.asList(values), ", "));
        }

        @Override
        public CodeBlock classReference(ClassName className) {
            return CodeBlock.of("$T.class", className);
        }
    }
}

