/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.language;

import io.spring.initializr.generator.language.Annotatable;
import io.spring.initializr.generator.language.Annotation;
import io.spring.initializr.generator.language.AnnotationContainer;
import io.spring.initializr.generator.language.ClassName;
import java.util.function.Consumer;

public class Parameter
implements Annotatable {
    private final String name;
    private final String type;
    private final AnnotationContainer annotations;

    @Deprecated(since="0.20.0", forRemoval=true)
    public Parameter(String type, String name) {
        this(new Builder(name).type(type));
    }

    private Parameter(Builder builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.annotations = builder.annotations.deepCopy();
    }

    public static Parameter of(String name, String type) {
        return new Builder(name).type(type).build();
    }

    public static Parameter of(String name, ClassName type) {
        return new Builder(name).type(type).build();
    }

    public static Parameter of(String name, Class<?> type) {
        return new Builder(name).type(type).build();
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public AnnotationContainer annotations() {
        return this.annotations;
    }

    public static class Builder {
        private final String name;
        private String type;
        private final AnnotationContainer annotations = new AnnotationContainer();

        Builder(String name) {
            this.name = name;
        }

        public Builder type(ClassName type) {
            return this.type(type.getName());
        }

        public Builder type(Class<?> type) {
            return this.type(type.getCanonicalName());
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder annotate(ClassName className) {
            return this.annotate(className, null);
        }

        public Builder annotate(ClassName className, Consumer<Annotation.Builder> annotation) {
            this.annotations.add(className, annotation);
            return this;
        }

        public Parameter build() {
            return new Parameter(this);
        }
    }
}

